/***************************************************************************
                          NewCdCompilationView.cpp  -  description
                             -------------------
    begin                : Sun Nov 18 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* QT includes */
#include <qpainter.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qgrid.h>
#include <qevent.h>
#include <qdir.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>

/* KDE includes */
#include <kcontainer.h>
#include <kmainwindow.h>
#include <kprogress.h>
#include <kio/job.h>
#include <kio/jobclasses.h>

/* cdbakeoven includes */
#include "NewCdCompilationView.h"
#include "CdboCompilationView.h"
#include "cdbakeoven.h"

#include "widgets/TargetTreeCntPanel.h"
#include "widgets/EstimatePnl.h"
#include "widgets/fileViews/DataCompilationTreeView.h"

NewCdCompilationView::NewCdCompilationView(CDBakeOvenApp * cdboApp, QWidget *parent, const char *name) :
			CdboCompilationView(cdboApp, parent, name){
	
	this->cdboApp = cdboApp;
	initView();
}

NewCdCompilationView::~NewCdCompilationView(){
}

void NewCdCompilationView::initView(){

// -------------------- TargetTreeCntPanel ------------------------
	targetCnt = new TargetTreeCntPanel(this);
	targetCnt->resize(10,10);

// --------------------  CompilationTreeView ------------------------
	compilView = new DataCompilationTreeView(this, "compilView");
  	compilView ->setFocusPolicy(QWidget::ClickFocus);
  	compilView ->setCDBOApp(cdboApp);

// --------------------  EstimatePnl ------------------------
  	estimate = new EstimatePnl(this,"estimate" );
  	compilView->setEstimate(estimate);
  	
  	
  	
//=============== SLOTS & SIGNALS =====================================
	
						
	
						
//////////////////////INNER//////////////////////////
							
	
	connect( targetCnt->getShowPropBtn(), SIGNAL(clicked()),
						compilView, SLOT(slotProperties()) );
	connect( targetCnt->getReloadBtn(), SIGNAL(clicked()),
						compilView, SLOT(slotReload()) );
	connect( targetCnt->getDeleteNodeBtn(), SIGNAL(clicked()),
						compilView, SLOT(remove()) );
	connect( targetCnt->getIsoPropBtn(), SIGNAL(clicked()),
						compilView, SLOT(compilSettingsSlot()) );
						
	connect( targetCnt->getCollapseTrgBtn(), SIGNAL(clicked()),
						compilView, SLOT(collapse()) );
	connect( targetCnt->getBurnBtn(), SIGNAL(clicked()),
						compilView, SLOT(createCD()) );
	connect( targetCnt->getCreateImgBtn(), SIGNAL(clicked()),
						compilView, SLOT(createISO()) );
						
						

	
}
//==============================
void NewCdCompilationView::saveOptions(){
	estimate->saveOptions();
}
//==============================
void NewCdCompilationView::showTargetControl(bool doShow){
	if(!doShow)
		targetCnt->hide();
	else
		targetCnt->show();
}
//==============================
void NewCdCompilationView::showEstimate(bool doShow){

	if(!doShow)
		estimate->hide();
	else
		estimate->show();
}
