/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2001-2002 The Caudium Group
 * Copyright  2001 Davies, Inc
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: fslayout.pike,v 1.2.2.1 2002/07/08 23:43:12 kiwi Exp $
 */
/*
 * See http://www.daviesinc.com/modules/ for more informations.
 */

#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <stdio.h>
#include <array.h>
//#include <simulate.h>

//! module: Freesite Layout
//!  A MODULE_FILTER to add a header and footer to pages that are being 
//!  served. Now caches the header and footer files in the Caudium cache 
//!  for improved performance.<br />Based on Chris Davies 
//!  <a href="http://www.daviesinc.com/modules/">module.</a>
//! type: MODULE_FILTER
//! inherits: module
//! inherits: caudiumlib
//! cvs_version: $Id: fslayout.pike,v 1.2.2.1 2002/07/08 23:43:12 kiwi Exp $

string myfilename = "";
string basedir = "";

constant module_type = MODULE_FILTER;
constant module_name = "Freesite Layout";
constant module_doc  = "A MODULE_FILTER to add a header and footer to pages "
                       "that are being served. Now caches the header and "
                       "footer files in the Caudium cache for improved "
                       "performance.<br />Based on Chris Davies <a href=\""
                       "http://www.daviesinc.com/modules/\">module.</a>";
constant module_unique = 1;
constant module_version = "fslayout.pike v0.2 7-July-2001";
constant thread_safe = 1;

void create()
{
  defvar("header", "NONE", "Header Filename", TYPE_FILE,
	 "The Real File name of the header -- including the path");
  defvar("footer", "NONE", "Footer Filename", TYPE_FILE,
	 "The Real File name of the footer -- including the path");
}

mapping filter( mapping result, object id, mapping defines)
{
  if(!result || result->type != "text/html" || (sizeof(id->not_query/"/")<3) ) {
    return result;
  }
  array(string) dbinfo;
  string        header,footer;

  dbinfo = cache_lookup("TemplateCache"+id->misc->host,"header");
  if (!(dbinfo)) {
    header = Stdio.read_bytes( QUERY(header) );
    dbinfo = ({
      "header",
      header
    });
    cache_set("TemplateCache"+id->misc->host,"header",dbinfo,30*60);
  } else {
    header = dbinfo[1];
  }
  dbinfo = cache_lookup("TemplateCache"+id->misc->host,"footer");
  if (!(dbinfo)) {
    footer = Stdio.read_bytes( QUERY(footer) );
    dbinfo = ({
      "footer",
      footer
    });
    cache_set("TemplateCache"+id->misc->host,"footer",dbinfo,30*60);
  } else {
    footer = dbinfo[1];
  }

  if(result->data) {
    result->data = header + result->data + footer;
  } else { 
//    result->data = header + result->file->read(0xefffffff, 1) + footer;
    result->data = header + result->file->read() + footer;
    m_delete(result, "file");
  }
  result->len = strlen(result->data);
  return result;
}

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: header
//! The Real File name of the header -- including the path
//!  type: TYPE_FILE
//!  name: Header Filename
//
//! defvar: footer
//! The Real File name of the footer -- including the path
//!  type: TYPE_FILE
//!  name: Footer Filename
//
