#!/bin/sh
set -e
# You can use this script to build catdvi 0.13 in case you don't have GNU make

###########################################################################
# configuration
###########################################################################

# if the C library has getopt_long()
#
# GETOPT=""
# CPPFLAGS="$CPPFLAGS -DCFG_HAS_GETOPT_LONG"
#
# else if the kpathsea library has getopt_long() -- it should
#
GETOPT=""
CPPFLAGS="$CPPFLAGS -DCFG_KPATHSEA_HAS_GETOPT_LONG"
#
# else
#
# GETOPT="getopt getopt1"

# if you have the kpathsea library
FINDTFM="kpathsea"
LDLIBS="-lkpathsea"
# else
# echo "sorry, you need the kpathsea library"
# exit 1

# set your C compiler and append any desired flags and libraries here
CC="gcc"
CFLAGS="$CFLAGS"
CPPFLAGS="$CPPFLAGS"
LDFLAGS="$LDFLAGS"

COMPILE="$CC $CFLAGS $CPPFLAGS -c"
LINK="$CC $LDFLAGS"

###########################################################################
# no user serviceable parts below
###########################################################################

# create autogenerated header files: glyphenm.h
$COMPILE -o adobe2h.o adobe2h.c
$LINK adobe2h.o  $LDLIBS -o adobe2h
./adobe2h > glyphenm.h

# create autogenerated header files: font encodings
$COMPILE -o pse2unic.o pse2unic.c
$COMPILE -o util.o util.c
$LINK pse2unic.o util.o  $LDLIBS -o pse2unic
cd enc
for x in *.enc; do
    y=`basename $x .enc`
    ../pse2unic -w $y.enc $y.h $y.tex
done
cd ..

# compile everything else
PIECES="catdvi bytesex fixword fntenc fontinfo outenc page readdvi regsta \
glyphops linebuf density sparse pageref vlist $FINDTFM $GETOPT"

for x in $PIECES; do
    $COMPILE -o $x.o $x.c
done

OBJFILES="util.o"
for x in $PIECES; do
    OBJFILES="$OBJFILES $x.o"
done

$LINK $OBJFILES $LDLIBS -o catdvi

# create the test cases
cd test
for x in *.tex; do
    latex $x
done
cd ..
