
#include <assert.h>

#include "ImagePanelYUV.h"

/**
  \class CImagePanelYUV
  \brief A simple CamPanel that displays YUV images from \ref CVideoDevice

  This class is placed right on top of CVideoDevice: it handles the YUV
  images. See alse \ref CImagePanelRGB
  
  Registers panel "image.yuv"
 */
 

/**
  \param video A \ref CVideoDevice object.
  \param parent The QWdiget parent object
  \param name The widget name
  \brief Constructor.
 */
CImagePanelYUV::CImagePanelYUV(CVideoDevice *video, QWidget *parent, const char *name)
	: CCamPanel("image.yuv", "Video image YUV", YUV420, TRUE, parent, name)
{
   assert(video != NULL);
   pVideo = video;
   SetSize(pVideo->GetSize());
   connect(pVideo, SIGNAL(Resized(const QSize &)), this, SLOT(SetSize(const QSize &)));
   connect(pVideo, SIGNAL(Notify()), this, SLOT(UpdateImage()));
}


// private

void CImagePanelYUV::UpdateImage()
{
   ImgY = *pVideo->GetY();
   ImgU = *pVideo->GetU();
   ImgV = *pVideo->GetV();
   update();
}


// public

/// overloaded

void CImagePanelYUV::hideEvent(QHideEvent *e)
{
#if TRACE_PANELSIGNALS
   qDebug("CImagePanelYUV::hideEvent()");
#endif   
   //CCamPanel::SetVisibility(new_vis);
   pVideo->EnableYUV(FALSE);
   QWidget::hideEvent(e);
}

void CImagePanelYUV::showEvent(QShowEvent *e)
{
#if TRACE_PANELSIGNALS
   qDebug("CImagePanelYUV::showEvent()");
#endif   
   pVideo->EnableYUV(TRUE);
   QWidget::showEvent(e);
}


