/**********************************************************************

	--- Qt Architect generated file ---

	File: SizeFrame.cc
	Last generated: Sat Dec 18 06:17:46 1999

 *********************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>

#include "SizeFrame.h"

#define Inherited CSizeFrameData

static unsigned short sizes[6][2] =
{
  { 128,  96 },
  { 160, 120 },
  { 176, 144 },
  { 320, 240 },
  { 352, 288 },
  { 640, 480 },
};

static int frames[8] =  { 4, 5, 8, 10, 15, 20, 25, 30 };

CSizeFrame::CSizeFrame(CVideoDevice *_video, QWidget* parent, const char* name) 
	: Inherited(parent, name), size(320, 240)
{
   QSize ms;
   
   pVideo = _video;
   fps = 0;
   setCaption("Picture size and framerate");
   GetCam(TRUE);

   /* Find maximum size, disable radio buttons that are too large */
   ms = pVideo->GetMaxSize();
   for (int i = 0; i < 6; i++) {
      if (ms.width() < sizes[i][0] ||
          ms.height() < sizes[i][1])
        ImageSize->find(i)->setEnabled(FALSE);
   }
   connect(pVideo, SIGNAL(Resized(const QSize &)), this, SLOT(SizeChanged(const QSize &)));
}


CSizeFrame::~CSizeFrame()
{
}


// private

void CSizeFrame::GetCam(bool First)
{
   int i, fs, ifs, nfs, diff, dev;
   QSize ns;
   
   ns = pVideo->GetSize();
   ifs = pVideo->GetFramerate();
   if (First) {
     org_size = ns;
     org_fps  = ifs;
   }
   SizeChanged(ns);
   
   // Determine closest matching framerate
   fs = -1;
   nfs = -1;
   dev = 9999;
   for (i = 0; i < 8; i++) {
      diff = abs(frames[i] - ifs);
      if (diff < dev) { // Closest so far...
        dev = diff;
        nfs = frames[i];
        fs = i;
      }
   }
   if (fs != -1)
     ImageFrames->setButton(fs);
   if (ns != size || nfs != fps) {
     size = ns;
     fps = nfs;
   }
}

void CSizeFrame::SetCam()
{
}


// private slots


/**
  \brief Pick up size changes (even if we do it ourselves!)
*/
void CSizeFrame::SizeChanged(const QSize &ns)
{
   int i, sz;

printf("CSizeFrame::SizeChanged(%dx%d)\n", ns.width(), ns.height());

   // Determine image size (this better be exact)
   sz = -1;
   for (i = 0; i < 6; i++) {
      if (ns.width()  == sizes[i][0] &&
          ns.height() == sizes[i][1]) {
        sz = i;
        break;
      }
   }
   // Set radio button group
   if (sz != -1)
     ImageSize->setButton(sz);
}

// protected

void CSizeFrame::ClickedSize(int s)
{
   if (pVideo == NULL)
     return;

   /* Try to set the cam to the desired size; this may trigger a Resized() signal */
   if (!pVideo->SetSize(sizes[s][0], sizes[s][1]))
     return;
//   GetCam(); // read back from cam
}

void CSizeFrame::ClickedRate(int f)
{
   if (pVideo == NULL)
     return;

   /* Leave flags intact */
   if (!pVideo->SetFramerate(frames[f], SnapShot->isChecked()))
     return;
   GetCam();
}

void CSizeFrame::ChangedRate()
{
   if (pVideo == NULL)
     return;

   if (!pVideo->SetFramerate(fps, SnapShot->isChecked()))
     return;
   GetCam();
}
