/**********************************************************************

	--- Qt Architect generated file ---

	File: CamDialogs.cc
	Last generated: Sat Dec 18 07:12:38 1999

 *********************************************************************/

/* This is the "main" dialog for the video setting... It consists 
   of a few dialogs that are placed in a "tab" dialog.
 */

#include "CamDialogs.h"

#define Inherited CCamDialogsData

CCamDialogs::CCamDialogs(CVideoDevice *_video, QWidget* parent, const char* name)
	: Inherited( parent, name )
{
   setCaption("Video settings");
   
   pVideo = _video;
   
   pSizeFrame = new CSizeFrame(pVideo, this);
   addTab(pSizeFrame, "Size && Frame");
   pVideoControl = new CVideoControl(pVideo, this);
   addTab(pVideoControl, "Video Controls");
   pVideoTuning = new CVideoTuning(pVideo, this);
   addTab(pVideoTuning, "Tuning");	
   if (pVideo->GetIntfName().find("Philips") == 0) {
     pPhilips = new CPhilipsControl(pVideo, this);
     addTab(pPhilips, "Philips extensions");
   }

   setOkButton("Close");
   setDefaultButton("Defaults"); // bug? If not used, the Ok button appears in the topleft corner
   
   connect(this, SIGNAL(defaultButtonPressed()), pVideoControl, SLOT(RestoreDefaults()));
}


CCamDialogs::~CCamDialogs()
{
}
