#ifndef WEBCAMVIEWER_HPP
#define WEBCAMVIEWER_HPP

#include <time.h>

#include <qpixmap.h>
#include <qbutton.h>
#include <qtimer.h>
#include <qurloperator.h>

#include "VideoDevice.h"

#include "gui/SnapshotSettingsDlg.h"
#include "gui/TimeSnapshot.h"

#include "CamWindow.h"
#include "CamDialogs.h"
#include "BasicPanel.h"
#include "ImagePanelRGB.h"
#include "ImagePanelYUV.h"

class CWebCamViewer: public CCamWindow
{
   Q_OBJECT
private:
   enum {
     pbt_controls,
     pbt_config,
     pbt_showsnap,
     pbt_snapshot,
     pbt_timesnap,
     pbt_MAX,
   } PushButtons;
   QPixmap ButtonPix[pbt_MAX];
   QToolButton *pButton[pbt_MAX];

   CVideoDevice *pVideo;	///< The video device
   CCamPanel *pViewer;		///< The main image viewer
   CBasicPanel *pLastSnapshot;	///< Extra panel that shows the last snapshot
   QTimer *SizeTimer;		///< Helper timer for adjustSize()

   SVideoOptions *pVOptions;	///< Our options
   CSnapshotSettingsDlg *pConfiguration;	///< Configuration dialog
   CCamDialogs *pSettings;	///< Settings dialog

   CTimeSnapDlg *pTimeSnapDlg;
   int SnapInterval, SnapCounter;
   QTimer *pSnapTimer;
   QLabel *pSnapLabel;

   /// Upload data
   struct {
     QUrlOperator *pClient;
     QUrl LocalUrl, RemoteUrl;
     int State;
     time_t StartTime;
     bool ErrorCondition;
     
     enum {
       NotConnected,
       Login,
       Binary,
       Idle,
       Uploading,
       Done
     };
   } Upload;

   void StartUpload(const QString &, bool);

private slots:
   void ClickedConfigurationDlg();
   void ConfigurationDlgClosed();
   
   // Settings dialog
   void ClickedSettingsDlg();
   void SettingsDlgClosed();

   void ClickedShowLastSnapshot();

   void ClickedTimeSnapDlg();
   void TimeSnapDlgClosed();
   void StartTimeSnap();
   void StopTimeSnap();
   void TimeSnapTick();

   void FTPStart(QNetworkOperation *);
   void FTPState(int, const QString &);
   void FTPDone(QNetworkOperation *);

   void TakeSnapshot();

protected:
   void RecalcTotalViewSize();

protected slots:
   void DeviceChangedSize(const QSize &size);
   void DeviceError(int err_no);

   void CallAdjustSize();

public:
   CWebCamViewer(CVideoDevice *video, const QSize &hint_size, QWidget *parent = 0, const char *name = 0);
   ~CWebCamViewer();   
};

#endif
