#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  DIALOGBOX screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "";
  CSESSION->screen = "dialogbox";				// Admin screen name
  if(!CSESSION->dialogstrings)
    CSESSION->dialogstrings = ({ MSG(M_DIALOGOK) });
  if(!CSESSION->dialogactions)
    CSESSION->dialogactions = ({ "actionmailindex" });

  contents = CAMAS.Parse.parse_html(contents,
                        ([
                         "camas_buttons"     : tag_dialogbox_screen,
                         ]),
                        ([
                         ]),
                        id);

  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  if (CSESSION->dialogtarget)
  {
    args->action = CSESSION->nexturl+CSESSION->dialogtarget;
    args->target = CSESSION->dialogtarget;
  }
  else
  {
    args->action = id->misc->camas->nextpage;
    args->target = id->misc->camas->target;
  }

  //oliv3: optional arguments
  if (CSESSION->dialogoptions)
  {
    foreach (CSESSION->dialogoptions, string option)
    {
      array opts = option / "=";

      mapping inputargs = ([ ]);
      inputargs->name = opts[0];
      inputargs->value= opts[1];
      inputargs->type = "hidden";
      contents += CAMAS.Tools.make_tag("input", inputargs);
    }
    CSESSION->dialogoptions = 0;
  }

  // TODO: unveil the CSESSION->dialogtarget mystery before using CAMAS.Tools.set_target()
  args->method = "post";
  out += CAMAS.Tools.make_container("form", args, contents);

  out += "<!-- End of screen_DIALOGBOX -->";
  return out;
}

/* code for dialogbox screen tags */
string tag_dialogbox_screen(string tag_name, mapping args, object id)
{
  string out = "";                                              // HTML to output

  switch(tag_name)
  {
  case "camas_buttons":
    //! tag: camas_buttons
    //!  Buttons for answering the dialogbox
    //! note: buttons that can be added to your formbutton provider file
    //!  - dialog_actionread
    //!  - dialog_actionindex
    //!  - dialog_actionmailindex
    //! note: screen: dialogbox
    foreach (indices (CSESSION->dialogstrings), int i)
    {
      out += CAMAS.Tools.formdrawbutton(id,"dialog_"+CSESSION->dialogactions[i],
                                        CSESSION->dialogactions[i],
                                        CSESSION->dialogstrings[i], args);
    }
    break;

  default:
    out += "<!-- " + tag_name + " is not supported yet -->";
    CDEBUG("tag_dialogbox_screen: " + tag_name + "is not supported yet");
  }

  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
