// Dear Emacs, please note this is a -*-text-*- file. Thank you.
//
// Caudium - An extensible World Wide Web server
// Copyright  2000-2004 The Caudium Group
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: language.pl,v 1.43.2.1 2004/01/21 11:57:30 vida Exp $
//

//
// The language template file format
// ---------------------------------
//
// Message definitions are formatted as follows:
//
// #define<TAB>NAME[<TAB>ID]<TAB>MESSAGE
//
// There MUST be only ONE tab character between the definition fields.
// Never enclose the message in double quotes! Below are few escape sequences
// you can use in the message text:
//
// \s - space (needed at the start and the end of message since the parser strips
//             both leading and trailing whitespace)
// \t - TAB (as above)
// \# - # sign (only needed at the start of message if you need it to start with #).
//      # used at the start of message makes this message a function invocation, and
//      not a string. It means that it won't be enclosed in the quotation marks in the
//      output.
//
// Comments starting with //! are "attached" to the message definition that follows them
// and output in the target file as an attachment of that same kind.
//
// The target file contains also another kind of entry market with the //#DIRECTIVE 
// comment. The following directives are defined:
//
//  ORIG - the line contains the original version of the string for change testing when
//         the translation and the template are combined.
//  FLAG - followed by several flags marks the state of this entry:
//           <changed>  - the entry has been changed in the original (default) file
//                        and the translation needs to be updated.
//           <new>      - new entry merged from the default file
//
//  Neither the attachment comment nor the directive comment should be edited by hand!!
//


// For the translation system internal usage. Not used by CAMAS.

//! Maintainer of this particular file
//#ORIG Xavier Beaudouin <kiwi@isdnet.net>
#define	TS_MAINTAINER	11111	Marek Habersack <grendel@caudium.net>

//! This file version
//#ORIG 1.0.0-dev
#define	TS_VERSION	11112	1.2.15

//! Output in camas_XX.pike as default message (translate it to your language)
//#ORIG \s** MISSING MESSAGE **\s
#define	TS_NOMSGFOUND	11113	\s** BRAK KOMUNIKATU **\s

//! Native language name
//#ORIG English
#define	TS_LANGNAME	11114	Polski

//! Language charset
//#ORIG iso-8859-1
#define	TS_CHARSET	11115	iso-8859-2

//! Character encodable in the above charset
//#ORIG ?
#define	TS_ENCCHAR	11116	?

//! CVS version of the file (leave set to $Id: language.pl,v 1.43.2.1 2004/01/21 11:57:30 vida Exp $ if you don't use CVS)
//#ORIG $Id: language.pl,v 1.43.2.1 2004/01/21 11:57:30 vida Exp $
#define	TS_CVSVER	11117	$Id: language.pl,v 1.43.2.1 2004/01/21 11:57:30 vida Exp $

//! The copyright string put in the target .pike file
//#ORIG 2000 The Caudium Group
#define	TS_COPYRIGHT	11118	2000-2004 The Caudium Group


// CAMAS Messages

//#ORIG Reply on top of the message
#define	M_PREPLYONTOP	Odpowied u szczytu wiadomoci

//#ORIG Add marked to attachments
#define	M_ADDMARKEDTOATTACHMENTS	Dodaj zaznaczone do zacznikw

//#ORIG (Name)
#define	M_NEWMBOXNAME	(Nazwa)

//#ORIG Default addressbook (not extended)
#define	M_PADDRESSBOOK	Domylna ksika adresowa (nierozszerzona)

//#ORIG AND
#define	M_SEARCHAND	ORAZ

//#ORIG Organization
#define	M_PORGANIZATION	Organizacja

//#ORIG Mail address
#define	M_PMAILADDRESS	Adres pocztowy

//#ORIG OK
#define	M_LOGIN_OK	OK

//#ORIG Attachments
#define	M_ATTACHMENTSHEADER	Zaczniki

//#ORIG <strong>Error:</strong> Failed to fetch mail. The mail might have a faulty format.<br />
#define	M_MAILMISSING	<strong>Bd:</strong> Prba cignicia wiadomoci nie powioda si. Wiadomo moe mie zy format.<br />

//#ORIG Name
#define	M_PNAME	Nazwa

//#ORIG Home phone
#define	M_HOMEPHONE	Tel. domowy

//#ORIG \#sprintf("[<< Prev %d]", @arg)
#define	M_BACKN	\#sprintf("[<< Poprzednie %d]", @arg)

//#ORIG From
#define	M_FROM	Od

//#ORIG Create a new mailbox
#define	M_CREATEMBOX	Utwrz now skrzynk

//#ORIG Address book
#define	M_ADDRESSBOOK	Ksika adresowa

//#ORIG Include mail when replying
#define	M_PINCLUDEMAIL	Docz orygina do odpowiedzi

//#ORIG Postal code
#define	M_POSTALCODE	Kod pocztowy

//#ORIG You can't search multiple mailboxes for now, please wait a few moments if you want this feature
#define	M_SEARCHCACHENOTFEEDED	Nie mona przeszukiwa wielu skrzynek jednoczenie. Ta opcja zostanie dodana wkrtce.

//#ORIG used
#define	M_USED	wykorzystane

//#ORIG Index filter
#define	M_INDEXNAMEFILTER	Filtr indeksu

//#ORIG End this CAMAS session ?
#define	M_ENDSESSION	Zakoczy sesj?

//#ORIG Work postal address
#define	M_WORKPOSTALADDRESS	Adres pracy

//#ORIG Sunday
#define	M_SUNDAY	niedziela

//#ORIG Sort on column
#define	M_PSORTCOLUMN	Sortuj wg kolumny

//#ORIG Move marked to
#define	M_MOVEMARKED	Przesu zaznaczone do

//#ORIG No filter
#define	M_NOADDRESSESFILTER	Brak filtru

//#ORIG Read next
#define	M_READNEXT	Czytaj nastpn

//#ORIG Windows users: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.
#define	M_WINDOWSBUG	Uytkownicy Windows: z powodu bdu w niektrych przegldarkach WWW, nazwy plikw mog by nieprawidowe. Mona tego unikn zastpujc kocowy znak \\ znakami \\\\ przed klikniciem przycisku 'Wylij'.

//#ORIG Select files to send. Press 'Ctrl' to toggle-select multiple files.
#define	M_SENDMOREFILES	Zaznacz pliki do wysania. Wcinij 'Ctrl' by zaznaczy wicej ni jeden plik.

//#ORIG Available fields
#define	M_AVAILABLEFIELDS	Dostpne pola

//#ORIG Change to
#define	M_SPELLCHANGETO	Zmien na

//#ORIG Send marked drafts
#define	M_SENDMARKEDDRAFTS	Wylij zaznaczone szkice

//#ORIG Continue
#define	M_CONTINUECOMPOSE	Kontynuuj

//#ORIG Mailbox (m/r/u/s)
#define	M_MBOXNAME	Skrzynka (m/r/u/s)

//#ORIG Check inboxes
#define	M_CHECKACTIVEMAILBOXES	Sprawd skrzynki

//#ORIG in the mail body
#define	M_SEARCHBODY	w tekcie wiadomoci

//#ORIG Add recipients
#define	M_ADDRECIPIENTS	Dodaj adresatw

//#ORIG User interface:
#define	M_USERINTERFACE	Interfejs uytkownika:

//#ORIG (Lines with headers in this format: header:value)
#define	M_PHEADERDESC	(Linie w formacie: nagwek:zawarto)

//#ORIG Total size
#define	M_TOTALSIZE	Rozmiar cakowity

//#ORIG (Select a field)
#define	M_SELECTFIELD	(Wybierz pole)

//#ORIG \#sprintf("You have %d Kb available for upload.",@arg)
#define	M_AVAILSPACE	\#sprintf("Masz %d Kb miejsca dla zaadowania plikw.",@arg)

//#ORIG Change sort order
#define	M_CHANGESORTORDER	Zmie sortowanie

//#ORIG Cancel
#define	M_CANCELSEND	Anuluj

//#ORIG Answered
#define	M_SHARED_BOXANSWERED	Odpowiedziane

//#ORIG Nickname
#define	M_NICKNAME	Nick

//#ORIG Description
#define	M_DESCRIPTION	Opis

//#ORIG Reply selected mails
#define	M_REPLYMARKED	Odpowiedz na zaznaczone wiadomoci

//#ORIG of
#define	M_OF	z

//#ORIG No answers matching you query
#define	M_NOSEARCHRESULTS	Brak odpowiedzi na zapytanie

//#ORIG Search in all mailboxes
#define	M_SEARCHALLMBOX	Szukaj we wszystkich skrzynkach

//#ORIG Thread
#define	M_THREADSHOW	Wtek

//#ORIG Index field
#define	M_INDEXNAMEEDITFIELDFILTER	Pole indeksu

//#ORIG Saturday
#define	M_SATURDAY	sobota

//#ORIG Delete marked
#define	M_DELETEMARKED	Usu zaznaczone

//#ORIG Mail was sent successfully, but save in folder failed.
#define	M_SENDSAVEFAILED	Poczta zostaa wysana prawidowo, lecz zapis do folderu nie powid si.

//#ORIG IMAP server
#define	M_IMAPSERVER	Serwer IMAP

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOK	Importuj ksik adresow

//#ORIG Read previous
#define	M_READPREV	Czytaj poprzedni

//#ORIG Next
#define	M_SPELLNEXT	Nastpny

//#ORIG Reply to all and move
#define	M_REPLYTOALLMOVE	Odpowiedz wszystkim i przesu

//#ORIG A
#define	M_ANSWEREDFLAG	O

//#ORIG Index field
#define	M_INDEXFIELDFILTER	Pole indeksu

//#ORIG Search in history
#define	M_HISTSEARCH	Szukaj w historii

//#ORIG Attachment list too big
#define	M_ATTACHTOOBIG	Lista zacznikw jest zbyt dua

//#ORIG Drafts
#define	M_BOXDRAFTS	Szkice

//#ORIG \#sprintf(There was a problem talking to the outgoing mail (SMTP) server, and the mail was not sent to %s. The recipient of the mail might not exist.", @arg)
#define	M_SMTPERROR	\#sprintf("Wystpi problem w komunikacji z serwerem poczty wychodzcej (SMTP)\ni poczta nie zostaa wysana %s. Adresat poczty moe by nieprawidowy.", @arg)

//#ORIG Extra headers
#define	M_PHEADER	Dodatkowe nagwki

//#ORIG Compose mail
#define	M_COMPOSEMAIL	Nowa wiadomo

//#ORIG Upload
#define	M_UPLOAD	Zaaduj

//#ORIG Thursday
#define	M_THURSDAY	czwartek

//#ORIG Imported fields
#define	M_IMPORTEDFIELDS	Pola zaimportowane

//#ORIG Surname
#define	M_SURNAME	Nazwisko

//#ORIG Save draft
#define	M_SAVEDRAFT	Zapisz szkic

//#ORIG \#sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg)
#define	M_CHARSETWARNING	\#sprintf("Uwaga! Nie mona odkodowa zestawu znakw \"%s\". Wiadomo jest wywietlana w postaci zakodowanej.",@arg)

//#ORIG Previous
#define	M_SPELLPREV	Poprzedni

//#ORIG Archive
#define	M_ARCHIVE	Archiwum

//#ORIG URI
#define	M_URI	URI

//#ORIG Answered mail folder
#define	M_PANSWEREDFOLDER	Folder z wiadomociami odpowiedzianymi

//#ORIG in subject
#define	M_SEARCHSUBJECT	w temacie

//#ORIG Edit the filter
#define	M_EDITFILTER	Edytuj filtr

//#ORIG Friday
#define	M_FRIDAY	pitek

//#ORIG You must select a mailbox to rename and supply a new name.
#define	M_NOMBOXERROR	Musisz zaznaczy skrzynk, ktrej nazw chcesz zmieni i poda now nazw

//#ORIG There was a problem talking to the mail (IMAP) server.<br>Please contact the administrator.
#define	M_IMAPERROR	Wystpi problem komunikacji z serwerem pocztowym (IMAP).\nProsz skontaktowa si z administratorem.

//#ORIG Send blind copy to administrator
#define	M_CHECKBCC	Wylij ukryt kopi do administratora

//#ORIG Index folder
#define	M_FILTERFOLDER	Folder indeksu

//#ORIG Reply
#define	M_REPLY	Odpowiedz

//#ORIG Enable <em>\"Show full headers\"</em>-button
#define	M_PSHOWHIDDENHEADERS	Uaktywnij przycisk <em>\"Wszystkie nagwki\"</em>

//#ORIG Sent
#define	M_SHARED_BOXSENTMAIL	Wysane

//#ORIG N
#define	M_NEWFLAG	N

//#ORIG Remove marked attachments
#define	M_REMOVEMARKEDATTACHMENTS	Usu zaznaczone zaczniki

//#ORIG Delete all addressbook
#define	M_DELETEALLADDRESS	Usu ca ksik adresow

//#ORIG in all headers
#define	M_SEARCHHEADERS	we wszystkich nagwkach

//#ORIG History
#define	M_HISTFLAG	Historia

//#ORIG Index field (click to select a field)
#define	M_INDEXNAMEFIELDFILTER	Pole indeksu (kliknij by wybra pole)

//#ORIG Wrong login or password. Try again.
#define	M_LOGINERROR	Nieprawidowy login lub haso. Sprbuj ponownie.

//#ORIG Recipients don't see each other
#define	M_SENDBLIND	Odbiorcy nie widz si wzajemnie

//#ORIG Rename a mailbox
#define	M_RENAMEMBOX	Zmienazw skrzynki

//#ORIG Enable or disable the background IMAP client started after your login. If the background IMAP client is enable, some features like fast search or faster mailboxes browsing are avaible. However the interface will be slower for a few minutes after you logged in.
#define	M_PENABLEDISABLECACHEFEEDER	Uaktywnij lub wycz program IMAP dziaajcy w tle po zalogowaniu si. Jeli program w tle jest aktywny, niektre waciwoci jak szybkie wyszukiwanie czy szybsze przegldanie skrzynek bd osigalne. Jednake interfejs uytkownika bdzie wolniejszy przez par minut po zalogowaniu.

//#ORIG Type
#define	M_MIMETYPE	Typ

//#ORIG Upload a Pine, an exported Netscape (.ldif) or Outlook (.csv) address book
#define	M_UPLOADADDRESSBOOK	Zaaduj ksik adresow Pine, wyeksportowan ksik Netscape (.ldif) lub Outlook (.csv)

//#ORIG Send
#define	M_SEND	Wylij

//#ORIG Wednesday
#define	M_WEDNESDAY	roda

//#ORIG Email address
#define	M_EMAILADDRESS	Adres email

//#ORIG Save a copy
#define	M_SAVEMAILCOPY	Zapisz kopi

//#ORIG Done
#define	M_SPELLDONE	Gotowe

//#ORIG Mobile
#define	M_MOBILE	Tel. komrkowy

//#ORIG in the 'to' field
#define	M_SEARCHTOFIELD	w polu 'Do'

//#ORIG Cancel
#define	M_CANCELADDRESSFILTER	Anuluj

//#ORIG \#sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0])
#define	M_SENDBROKENADDR	\#sprintf("Adres \"%s\" nie jest prawidowym adresem email. Popraw go i sprbuj ponownie.", arg[0])

//#ORIG Language
#define	M_PLANGUAGE	Jzyk

//#ORIG Report delivery
#define	M_MDN	Potwierd dostarczenie

//#ORIG \#sprintf ("<b>Could not log in:</b> %s", @arg)
#define	M_NOLOGIN	<strong>Zalogowanie niemoliwe:</strong>

//#ORIG Common addresses:
#define	M_GLOBALADDRESSES	Adresy dzielone:

//#ORIG Current Mailbox
#define	M_CURRMAILBOX	Aktywna Skrzynka

//#ORIG Info
#define	M_INFO	Informacja

//#ORIG Move to trash
#define	M_MOVETHISTOTRASH	Przesu do kosza

//#ORIG Folder
#define	M_ADDRESSFILTER	Folder

//#ORIG -------------
#define	M_FWD_REP_SEP	-------------

//#ORIG M
#define	M_MARKFLAG	Z

//#ORIG Manual correction
#define	M_MANUALCORRECTION	Rczne poprawki

//#ORIG Delay
#define	M_DELAY	Opoznienie

//#ORIG Default Bcc address
#define	M_PDEFAULTBCC	Domylny adres Bcc

//#ORIG Answered
#define	M_BOXANSWERED	Odpowiedziane

//#ORIG Password:
#define	M_PASSWORD	Haso:

//#ORIG Size
#define	M_SIZE	Rozmiar

//#ORIG Tuesday
#define	M_TUESDAY	wtorek

//#ORIG Trash
#define	M_SHARED_BOXTRASH	Kosz

//#ORIG Select
#define	M_SELECT	Select

//#ORIG Report successful delivery.
#define	M_DSN_SUCCESS	Potwierd dostarczenie poczty

//#ORIG \#sprintf ("%s requested a receipt to be returned. Do you wish to send one ?", @arg)
#define	M_NOTIFYTO	\#sprintf ("%s zarzda potwierdzenia odbioru wiadomoci. Czy zgadzasz si na wysanie potwierdzenia?", @arg)

//#ORIG Filters
#define	M_FILTERBOOK	Filtry

//#ORIG Pager
#define	M_PAGER	Pager

//#ORIG Search
#define	M_SEARCHMAIL	Szukaj

//#ORIG in the 'from' field
#define	M_SEARCHFROMFIELD	w polu 'Od'

//#ORIG Sent mail folder
#define	M_PSENTFOLDER	Folder poczty wysanej

//#ORIG Back to mail index
#define	M_BACKTOMAILINDEX	Powrt do indeksu poczty

//#ORIG Question
#define	M_QUESTION	Pytanie

//#ORIG Logout
#define	M_LOGOUT	Wyloguj

//#ORIG The Pine address book is often in ~/.addressbook
#define	M_PINELOCATION	Ksika adresowa Pine czsto znajduje si w ~/.addressbook

//#ORIG Search and replace
#define	M_SEARCHREPLACE	Szukaj i zmie

//#ORIG To:
#define	M_FWD_TO	Do:

//#ORIG Received
#define	M_RECEIVED	Otrzymane

//#ORIG Show full headers
#define	M_SHOWFULLHEADERS	Wszystkie nagwki

//#ORIG Address(es), comma separated
#define	M_ADDRESSFORMAT	Adres(y), rozdzielone przecinkami

//#ORIG Delete filter
#define	M_DELETEADDRESSFILTER	Usu filtr

//#ORIG Mark all
#define	M_MARKALL	Zaznacz wszystko

//! Label on the login screen
//#ORIG Login:
#define	M_LOGIN	Login:

//#ORIG Sent
#define	M_BOXSENTMAIL	Wysane

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENTFILTER	Nazwa indeksu (kliknij by doda jako adresata)

//#ORIG Filename
#define	M_FILENAME	Nazwa pliku

//#ORIG Monday
#define	M_MONDAY	poniedziaek

//#ORIG No spelling errors found.
#define	M_NOSPELLINGERRORS	Nie znaleziono bdw pisowni.

//#ORIG Cannot import this addressbook, since its\nformat is not recognized.
#define	M_CANNOTIMPORT	Nie mona zaimportowa tej ksiki adresowej gdy\njej format jest nieznany.

//#ORIG Report delayed delivery.
#define	M_DSN_DELAY	Powiadom o opnionym dostarczeniu

//#ORIG Select matching fields
#define	M_SELECTMATCHINGFIELDS	Wybierz pasujce pola

//#ORIG Delete marked
#define	M_DELETEMARKEDMBOX	Usu zaznaczone

//#ORIG Work country
#define	M_WORKCOUNTRY	Kraj zatrudnienia

//#ORIG Get new mail
#define	M_GETNEWMAIL	Odbierz now poczt

//#ORIG Index name
#define	M_INDEXNAME	Nazwa indeksu

//#ORIG From preferences
#define	M_SAVEDUSERINTERFACE	Z ustawie

//#ORIG Please mark some messages first.
#define	M_DELETEMARKEDNONE	Zaznacz uprzednio kilka wiadomoci.

//#ORIG Trash folder
#define	M_PTRASHFOLDER	Kosz

//#ORIG User interface
#define	M_PUSERINTERFACE	Interfejs uytkownika

//#ORIG Preferences
#define	M_PREFS	Ustawienia

//#ORIG Logged out
#define	M_LOGGEDOUT	Wylogowany

//#ORIG Cancel
#define	M_CANCELADDRESS	Anuluj

//#ORIG You must specify a recipient of the mail.
#define	M_SENDNORECV	Musisz poda adresata.

//#ORIG Fwd:
#define	M_FWD_SUBJECT	Fwd:

//#ORIG Add file as an attachment
#define	M_ADDFILEASATTACHMENT	Dodaj jako zacznik

//#ORIG Date
#define	M_DATE	Data

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENT	Nazwa indeksu (kliknij by doda jako adresata)

//#ORIG [No mail]
#define	M_NOMAILS	[Brak poczty]

//#ORIG Edit filter
#define	M_EDITADDRESSFILTER	Edytuj filtr

//#ORIG Default screen after successful login
#define	M_PPOSTLOGINSCREEN	Ekran pokazywany po zalogowaniu si

//#ORIG \#([ "forward": "forward", "backward":"backward"])[arg[0]]
#define	M_PSORTORDERS	\#([ "forward": "w przd", "backward":"w ty"])[arg[0]]

//#ORIG Trash
#define	M_BOXTRASH	Kosz

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOKTITLE	Importuj ksik adresow

//#FLAG <new>
//#ORIG Quota
#define	M_QUOTA	Quota

//#ORIG Don't remember the previous search
#define	M_NOSEARCHREMEMBER	Nie zapamituj poprzedniego wyszukiwania

//#ORIG Today
#define	M_TODAY	dzi

//#ORIG Work city
#define	M_WORKCITY	Miasto zatrudnienia

//#ORIG Back
#define	M_MAILMISSINGBACK	Powrt

//#ORIG Save and use
#define	M_SAVEADDRESS	Zapisz i uyj

//#ORIG Save and use
#define	M_SAVEADDRESSFILTER	Zapisz i uyj

//#ORIG Move marked to trash
#define	M_MOVETOTRASH	Przesu zaznaczone do kosza

//#ORIG Search LDAP
#define	M_SEARCHLDAP	Przeszukuj LDAP

//#ORIG Index filter (click to edit)
#define	M_INDEXNAMEEDITFILTER	Filtr indeksu (kliknij by edytowa)

//#ORIG Files
#define	M_FILES	Pliki

//#ORIG Return Receipt (displayed) -\s
#define	M_MDNHEADER	Potwierdzenie Odbioru (wywietlane) -\s

//#ORIG Delete address
#define	M_DELETEADDRESS	Usu adres

//#ORIG Reply to all
#define	M_REPLYTOALL	Odpowiedz wszystkim

//#ORIG Reply-To:
#define	M_FWD_REPLYTO	Reply-To:

//#ORIG Attachments
#define	M_ATTACHMENTS	Zaczniki

//#ORIG Messages shown in a mailbox
#define	M_PVISIBLEMESSAGES	Wiadomoci pokazywane w folderze

//#ORIG Add to address book
#define	M_ADDADDRESS	Dodaj do ksiki adresowej

//#ORIG Company
#define	M_COMPANY	Firma

//#ORIG \#sprintf("Are you sure you want to delete the %d marked message(s)?", @arg)
#define	M_DELETEMARKEDP	\#sprintf("Czy jeste pewien, e chcesz usun %d zaznaczonych odpowiedzi?", @arg)

//#ORIG Suggestions
#define	M_SPELLSUGGESTIONS	Sugestie

//#ORIG Path
#define	M_FOLDER_PATH	cieka

//#ORIG Mail sort order
#define	M_PSORTORDER	Porzdek sortowania

//#ORIG Reload this page to login.
#define	M_LOGOUTRELOAD	Przeaduj t stron by zalogowa si ponownie.

//#ORIG New
#define	M_NEW	Nowy

//#ORIG \#sprintf("This is a Return Receipt for the mail that you sent to %s.Note: this Return Receipt only acknowledges that the message was displayed on the recipient's machine. There is no guarantee that the content has been read or understood.", @arg)
#define	M_MDNMESSAGE	\#sprintf("Potwierdzenie Odbioru poczty, ktr wysae do %s. Uwaga: niniejsze Potwierdzenie Odbioru jest jedynie sygnaem, i wiadomo zostaa <strong>wywietlona</strong> na ekranie komputera adresata. Nie ma gwarancji, e zawarto zostaa przeczytana i/lub zrozumiana.", @arg)

//#ORIG No files
#define	M_NOATTACHFILES	Brak plikw

//#ORIG Subject
#define	M_SUBJECT	Temat

//#ORIG Department
#define	M_DEPARTMENT	Dzia

//#ORIG Empty the trash folder
#define	M_DELETEALLTRASH	Oprnij kosz

//#ORIG Search name containing:
#define	M_NAMECONT	Znajd nazw zawierajc:

//#ORIG anywhere
#define	M_SEARCHANYWHERE	gdziekolwiek

//#ORIG Drafts
#define	M_SHARED_BOXDRAFTS	Szkice

//#ORIG New filter
#define	M_NEWADDRESSFILTER	Nowy filtr

//#ORIG Upload to attachments
#define	M_UPLOADTOATTACHMENTS	Dodaj do zacznikw

//#ORIG LDAP search
#define	M_LDAP	Wyszukiwanie w LDAP

//#ORIG New address
#define	M_NEWADDRESS	Nowy adres

//#ORIG Mailboxes
#define	M_MAILBOXES	Skrzynki

//#ORIG Close this browser window to make sure no one can read your mail.
#define	M_LOGOUTCLOSE	Zamknij okienko przegldarki by upewni si, i nikt nie bdzie mg przeczyta Twojej poczty.

//#ORIG Cancel
#define	M_DIALOGCANCEL	Anuluj

//#ORIG Mail is too big to be shown. Click here to download it.
#define	M_MAILTOOBIG	Wiadomo jest zbyt dua by j pokaza. Kliknij tutaj by j cign.

//#ORIG From:
#define	M_FWD_FROM	Od:

//#ORIG \#sprintf("%sattachment of type %s",@arg)
#define	M_ATTACHMENTLINK	\#sprintf("%szacznik typu %s",@arg)

//#ORIG Home postal address
#define	M_HOMEPOSTALADDRESS	Adres domowy

//#ORIG Edit address
#define	M_EDITADDRESS	Edytuj adres

//#ORIG Add attachment
#define	M_ADDATTACHMENT	Dodaj zacznik

//#ORIG #
#define	M_NUMBER	#

//#ORIG Title
#define	M_TITLE	Tytu

//#ORIG Save and use
#define	M_PSAVEANDUSE	Zapisz i uyj

//#ORIG Inbox
#define	M_INBOX	Skrzynka gwna

//#ORIG Mail Filter
#define	M_FILTERBOOKTITLE	Filtr Poczty

//#ORIG Unseen
#define	M_UNSEEN	Nieprzeczytane

//#ORIG You have been logged out.
#define	M_LOGOUTMSG	Zostae wylogowany.

//#ORIG Default filterbook (not extended)
#define	M_PADDRESSBOOKFILTER	Domylny zestaw filtrw (nierozszerzony)

//#ORIG OK
#define	M_DIALOGOK	OK

//#ORIG Mail
#define	M_MAIL	Poczta

//#ORIG Hide full headers
#define	M_HIDEFULLHEADERS	Ukryj dodatkowe nagwki

//#ORIG Destination to import to
#define	M_DESTINATIONIMPORT	Lokalizacja docelowa importu

//#ORIG Back to compose
#define	M_BACKTOCOMPOSE	Powrt do edycji

//#ORIG Bcc
#define	M_BCC	Bcc

//#ORIG Send market drafts and move
#define	M_SENDMARKEDDRAFTSMOVE	Wylij zaznaczone szkice i przesu

//#ORIG Continue and move
#define	M_CONTINUECOMPOSEMOVE	kontynuuj i przesu

//#ORIG Problem while writing to address book
#define	M_ADDRESSBOOKWRITEPROBLEM	Problem zapisu w ksice adresowej

//#ORIG LDAP addresses
#define	M_LDAPTITLE	Adresy LDAP

//#ORIG Type in a name first.
#define	M_NEWMBOXNONAME	Podaj nazw

//#ORIG Address
#define	M_ADDRESS	Adres

//#ORIG [Previous level]
#define	M_PREVIOUS_LEVEL	[Poprzedni poziom]

//#ORIG \#sprintf("Mailbox: %s",@arg)
#define	M_MAILBOX	\#sprintf("Skrzynka: %s",@arg)

//#ORIG Recipients don't see each other button
#define	M_PSENDBLIND	Przycisk 'odbiorcy nie widz siebie wzajemnie'

//#ORIG Include attachments
#define	M_PSAVEATTACHMENTS	Razem z zacznikami

//#ORIG No
#define	M_NO	Nie

//#ORIG Date:
#define	M_FWD_DATE	Date:

//#ORIG Delete marked
#define	M_DELETEMARKEDFILES	Usu zaznaczone

//#ORIG Search mail
#define	M_SEARCHMAILTITLE	Przeszukaj poczt

//#ORIG No attachments
#define	M_NOATTACHMENTS	Brak zacznikw

//#ORIG Failed to rename mailbox. The name may be illegal or the mailbox may exist.
#define	M_RENAMEMBOXERROR	Prba zmiany nazwy skrzynki nie powioda si. Nazwa moe by nieprawidowa lub skrzynka o takiej nazwie moe ju istnie.

//#ORIG Work state
#define	M_WORKSTATE	Stan zatrudnienia

//#ORIG Next
#define	M_EFORWARDN	Dalej

//#ORIG To
#define	M_TO	Do

//#ORIG Mark at least one mailbox.
#define	M_MBOXMARKONE	Zaznacz co najmniej jedn skrzynk

//#ORIG Signature
#define	M_PSIGNATURE	Podpis

//#ORIG Messages
#define	M_MESSAGES	Wiadomoci

//#ORIG You must specify at least the field(s)
#define	M_MUSTSELECTFIELD	Musisz wybra przynajmniej te pole(a)

//#ORIG Compose
#define	M_NEWMAIL	Nowa wiadomo

//#ORIG Showing mail with\s
#define	M_SEARCHSHOWINGMAIL	Pokazywane wiadomoci z\s

//#ORIG Forward and move
#define	M_FORWARDMOVE	Przelij dalej i przesu

//#ORIG Add to filter book
#define	M_ADDADDRESSFILTER	Dodaj do zestawu filtrw

//#ORIG Cc
#define	M_CC	Cc

//#ORIG Port
#define	M_PORT	Port

//#ORIG \#sprintf("Mail %d-%d of %d", @arg)
#define	M_MAILSHOWN	\#sprintf("Wiadomo %d-%d z %d", @arg)

//#ORIG Delete
#define	M_DELETE	Usu

//#ORIG Upload and import
#define	M_UPLOADANDIMPORT	Zaaduj i importuj

//#ORIG Do not save this mail
#define	M_DONTSAVEMAIL	Nie zapisuj tej wiadomoci

//#ORIG \#sprintf("[Next %d >>]", @arg)
#define	M_FORWARDN	\#sprintf("[Nastpne %d >>]", @arg)

//#ORIG OU
#define	M_OU	OU

//#ORIG Are you sure you want to delete the following mailboxes?
#define	M_MBOXREMOVEP	Czy jeste pewien, e chcesz usun ponisze skrzynki?

//#ORIG No addresses
#define	M_NOADDRESSES	Brak adresw

//#ORIG Show all
#define	M_SHOWALLAFTERSEARCH	Poka wszystko

//#ORIG Drafts folder
#define	M_PDRAFTSFOLDER	Folder szkicw

//#ORIG You must specify non-empty index folder and filter(s).
#define	M_EMPTYADDRESSFILTER	Musisz wskaza folder indeksw oraz filtr(y).

//#ORIG Yes
#define	M_YES	Tak

//#ORIG Forward
#define	M_FORWARD	Przelij dalej

//#ORIG Mail searchpath
#define	M_PMAILPATH	cieka wyszukiwania poczty

//#ORIG Cc:
#define	M_FWD_CC	Cc:

//#ORIG Reply and move selected mails
#define	M_REPLYMOVEMARKED	Odpowiedz na i przesu zaznaczone wiadomoci

//#ORIG With this option a rule is automatically build when you move a mail to a specified mailbox. When the same sender come back,  his mail is moved to th mailbox you already specified
#define	M_PAUTOFILTER	Z t opcj filtr jest tworzony automatycznie kiedy przesuniesz wiadomo do konkretnej skrzynki. Gdy nadawca ponownie napisze jego wiadomo zostanie przesunita do skrzynki, ktor uprzednio wskazae.

//#ORIG Check for new mail
#define	M_CHECKNEWMAIL	Sprawd poczt

//#ORIG There was a problem talking to the addressbook server (LDAP)
#define	M_ADDRBOOKERRROR	Wystpi problem komunikacji z serwerem ksiki adresowej (LDAP)

//#ORIG Inactive logout (minutes)
#define	M_PINACTIVELOGOUT	Automatyczne wylogowanie (minuty)

//#ORIG Time
#define	M_TIME	Czas

//#ORIG Work phone
#define	M_WORKPHONE	Tel. w pracy

//#ORIG Prefix
#define	M_PQUOTEPREFIX	Przedrostek

//#ORIG Failed to create mailbox. The name may be illegal or the mailbox may exist.
#define	M_CREATEMBOXERROR	Nie mona utworzy skrzynki. Nazwa moe by nieprawidowa lub skrzynka moe ju istnie.

//#ORIG Index name (click to edit)
#define	M_INDEXNAMEEDIT	Nazwa indeksu (kliknij by edytowa)

//#ORIG Folder
#define	M_FOLDER	Folder

//#ORIG Upload attachment
#define	M_UPLOADATTACHMENT	Zaaduj zacznik

//#ORIG Show text messages
#define	M_PSHOWTEXT	Pokazuj wiadomoci tekstowe

//#ORIG Sticky Filter
#define	M_STICKYFILTER	Stay Filtr

//#ORIG Address Book
#define	M_ADDRESSBOOKTITLE	Ksika Adresowa

//#ORIG ------ Forwarded message ------
#define	M_FWD_SEP	------ Przekazana wiadomo ------

//#ORIG Show HTML messages
#define	M_PSHOWHTML	Pokazuj wiadomoci HTML

//#ORIG Select a mailbox
#define	M_SELECTMBOX	Wybierz skrzynk

//#ORIG \#sprintf ("The mail \"%s\" was sent to: %s", @arg)
#define	M_SMTPOK	\#sprintf ("Wiadomo \"%s\" zostaa wysana do: %s", @arg)

//#ORIG Spell check
#define	M_SPELLCHECK	Sprawd pisowni

//#ORIG Reply and move
#define	M_REPLYMOVE	Odpowiedz i przesu

//#ORIG Mail notification
#define	M_MAILNOTIFYWINDOW	Powiadomienie o poczcie

//#ORIG You have no uploaded files
#define	M_NOFILES	Nie masz adnych zaadowanych plikw

//#ORIG Prev
#define	M_EBACKN	Wstecz

