/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: globals.h,v 1.38 2004/01/13 11:01:36 vida Exp $
 */

#ifndef __GLOBALS_H
#define __GLOBALS_H

#include "screens.h"
#include "features.h"
#include "compat.h"

// infos on emails
#define DATE_IDX      0
#define SUBJECT_IDX   1
#define FROM_IDX      2
#define SENDER_IDX    3
#define REPLAYTO_IDX  4
#define TO_IDX        5
#define CC_IDX        6
#define BCC_IDX       7
#define INREPLYTO_IDX 8
#define MESSAGEID_IDX 9

#define MB_NOSELECT 1
#define MB_NOINFERIORS 2
#define MB_IMPLICIT_FOLDER 4
#define MB_PREVIOUS_FOLDER 8
// ({ foldername, displayname, flags, separator, foldername/separator })
#define MB_FOLDERNAME_IDX 0
#define MB_DISPLAYNAME_IDX 1
#define MB_FLAGS_IDX 2
#define MB_SEPARATOR_IDX 3
#define MB_HIERARCHY_IDX 4

// infos on folders
#define MB_MESSAGES_IDX 0
#define MB_RECENT_IDX 1
#define MB_UNSEEN_IDX 2
#define MB_SIZE_IDX 3
#define MB_NEXTUID_IDX 4 // folder has changed: ((#msg_old != #msg_new) || (#next_uid_old != #next_uid_new))
#define MB_UNKNOWN_SIZE -1

#ifndef VAR_INITIAL
#define VAR_INITIAL 0
#endif

// extended address book
#define HEADER_EBOOK_FIELDS "x-ebook-fields" /* keep headers LOWERCASE !!! */
#define HEADER_EBOOK_SUBJECT_VALUE "IMHO Extended Addressbook"

#define SIZE_SHIFT 20
#define IMAP_MDN_FLAG "$MDNSent"

// IMAP-Client
#define MODE_LINE 0
#define MODE_PARSE 1
#define TIMEOUT1 60 

#define IMAP_QSTRING(x) ("\""+replace(x,({"\"","\\"}),({"\\\"","\\\\"}) )+"\"")

#if constant(thread_create)
#define LOCK_FEEDER() if(sessobj && !sessobj->cachefeeded) _lock = sessobj->lock->lock();
#define UNLOCK_FEEDER() if(sessobj && !sessobj->cachefeeded) destruct(_lock);
#define SHARED_LOCK() _lock = camas_main->global_lock->lock();
#define SHARED_UNLOCK() destruct(_lock);
#else
#define LOCK_FEEDER()
#define UNLOCK_FEEDER()
#define SHARED_LOCK()
#define SHARED_UNLOCK()
#endif

// rfc822 date format
#define DD_INDEX	0
#define MM_INDEX	1
#define YY_INDEX	2
#define HOURS_INDEX	3
#define MINUTES_INDEX	4
#define SECONDS_INDEX	5
#define YYYY_INDEX	6
#define TZ_INDEX	7
#define WDAY_INDEX	8
#define YDAY_INDEX      9

// camas session shortcuts
#define CSESSION  id->misc->session_variables->CAMAS

// camas main module
#define CAMAS_MODULE    id->conf->get_provider("camas_main")

// camas language module
#define CAMAS_LANGUAGE  id->conf->get_provider ("camas_lang")

// camas features module
#define CAMAS_FEATURES  id->conf->get_provider("camas_features")

// timeout for the caches used in Camas in seconds
#define CACHE_TIMEOUT	3600

// is debug enabled by default ?
//#define CAMAS_DEBUG

// if you want folders debug (very verbose)
//#define CAMAS_FOLDERS_DEBUG

// if you want IMAP cache debug (very verbose)
//#define CAMAS_IMAPCACHE_DEBUG

// debug macros
#ifdef CAMAS_DEBUG
#define CDEBUG(X) if(QUERY(debug)) { report_debug("CAMAS DEBUG\t"+__FILE__+"@"+__LINE__+": "+X+"\n"); }
#define IMAP_DEBUG(X) if(sessobj && sessobj->debug) { report_debug("CAMAS_DEBUG\timapclient@"+__LINE__+": "+ X); }
#define DATE_DEBUG(X) { report_debug("CAMAS_DEBUG\tDateTools.pmod@"+__LINE__+": "+ X); }
#define LDAP_DEBUG(X) { report_debug("CAMAS_DEBUG\tLDAP.pmod@"+__LINE__+": "+ X); }
#define RXML_CACHE_DEBUG(X) { if(rxml_debug) report_debug("CAMAS_DEBUG\tcamas_tags@"+__LINE__+": "+X+"\n"); }
#else
#define CDEBUG(X)
#define IMAP_DEBUG(X)
#define DATE_DEBUG(X)
#define LDAP_DEBUG(X)
#define RXML_CACHE_DEBUG(X)
#endif

#ifdef CAMAS_FOLDERS_DEBUG
#define FOLDERS_DEBUG(X) { report_debug("CAMAS_DEBUG\tFolderTools.pmod@"+__LINE__+": "+ X); }
#else
#define FOLDERS_DEBUG(X)
#endif

#ifdef CAMAS_IMAPCACHE_DEBUG
#define IMAPCACHE_DEBUG(X) if(sessobj && sessobj->debug) { report_debug("CAMAS_DEBUG\timapclient@"+__LINE__+": Cache: "+ X); }
#else
#define IMAPCACHE_DEBUG(X)
#endif

#endif // __GLOBAL_H
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

