/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2001 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: screens.h,v 1.2 2001/01/13 04:16:31 neotron Exp $
 */

#include "language.h"

#define LOGINPROMPT -1
#define LOGINFAILED -2
#define LOGINFAILEDIMAP -3

#define MAINMENU 3
#define LOGOUT 4
#define SETUP 5
#define COMPOSE 6
#define MAILINDEX 7
#define READMAIL 8
#define FOLDERLIST 9
#define FILES 10
#define DIALOGBOX 11
#define SPELLCHECK 12
#define ATTACHMENTS 13
#define ADDRESSBOOK 14
#define EDITADDRESS 15
#define IMPORTADDRESS 16
#define LDAPSEARCH 17
#define LDAPRESULT 18
#define ADMINMAIN 19
#define SEARCHMAIL 20
#define MAILFILTER 21
#define EDITADDRESSFILTER 22
#define ADDRESSBOOK2 23
#define LDAPRESULT2 24
#define MDNDIALOG 25

constant screennames = ([
  LOGINPROMPT : ({ "login", -1 }), 
  LOGINFAILED : ({ "login", -1 }), 
  LOGINFAILEDIMAP : ({ "login", -1 }), 
  LOGOUT : ({ "logout", M_LOGGEDOUT }), 
  SETUP : ({ "setup", M_PREFS }), 
  COMPOSE : ({ "compose", M_COMPOSEMAIL }),
  MAILINDEX : ({ "mailindex", M_CURRMAILBOX }),
  READMAIL : ({ "readmail", M_MAIL }),
  FOLDERLIST : ({ "folderlist", M_MAILBOXES }),
  FILES : ({ "files", M_FILES }),
  DIALOGBOX : ({ "dialogbox", M_INFO }),
  SPELLCHECK : ({ "spellcheck", M_SPELLCHECK }),
  ATTACHMENTS : ({ "attachments", M_ATTACHMENTSHEADER }),
  MAILFILTER : ({ "filterbook", M_FILTERBOOKTITLE }),
  EDITADDRESSFILTER : ({ "editaddressfilter", M_FILTERBOOKTITLE }),
  ADDRESSBOOK : ({ "addressbook", M_ADDRESSBOOKTITLE }),
  ADDRESSBOOK2 : ({ "addressbooktoccbcc", M_ADDRESSBOOKTITLE }),
  EDITADDRESS : ({ "editaddress", M_ADDRESSBOOKTITLE }),
  IMPORTADDRESS : ({ "importaddress", M_ADDRESSBOOKTITLE }),
  LDAPSEARCH : ({ "ldapsearch", M_LDAPTITLE}),
  LDAPRESULT : ({ "ldapresult", M_LDAPTITLE}),
  LDAPRESULT2 : ({ "ldapresulttoccbcc", M_LDAPTITLE}),
  SEARCHMAIL : ({ "searchmail", M_SEARCHMAILTITLE})
]);

