// Dear Emacs, please note this is a -*-text-*- file. Thank you.
//
// Caudium - An extensible World Wide Web server
// Copyright  2000-2001 The Caudium Group
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: language.pl,v 1.11.2.1 2001/07/10 17:49:34 kiwi Exp $
//

//
// The language template file format
// ---------------------------------
//
// Message definitions are formatted as follows:
//
// #define<TAB>NAME[<TAB>ID]<TAB>MESSAGE
//
// There MUST be only ONE tab character between the definition fields.
// Never enclose the message in double quotes! Below are few escape sequences
// you can use in the message text:
//
// \s - space (needed at the start and the end of message since the parser strips
//             both leading and trailing whitespace)
// \t - TAB (as above)
// \# - # sign (only needed at the start of message if you need it to start with #).
//      # used at the start of message makes this message a function invocation, and
//      not a string. It means that it won't be enclosed in the quotation marks in the
//      output.
//
// Comments starting with //! are "attached" to the message definition that follows them
// and output in the target file as an attachment of that same kind.
//
// The target file contains also another kind of entry market with the //#DIRECTIVE 
// comment. The following directives are defined:
//
//  ORIG - the line contains the original version of the string for change testing when
//         the translation and the template are combined.
//  FLAG - followed by several flags marks the state of this entry:
//           <changed>  - the entry has been changed in the original (default) file
//                        and the translation needs to be updated.
//           <new>      - new entry merged from the default file
//
//  Neither the attachment comment nor the directive comment should be edited by hand!!
//


// For the translation system internal usage. Not used by CAMAS.

//! Maintainer of this particular file
//#ORIG Xavier Beaudouin <kiwi@isdnet.net>
#define	TS_MAINTAINER	11111	Marek Habersack <grendel@caudium.net>

//! This file version
//#ORIG 1.0.0-dev
#define	TS_VERSION	11112	0.2

//! Output in camas_XX.pike as default message (translate it to your language)
//#ORIG \s** MISSING MESSAGE **\s
#define	TS_NOMSGFOUND	11113	\s** BRAK KOMUNIKATU **\s

//! Native language name
//#ORIG English
#define	TS_LANGNAME	11114	Polski

//! Language charset
//#ORIG iso-8859-1
#define	TS_CHARSET	11115	iso-8859-2

//! Character encodable in the above charset
//#ORIG ?
#define	TS_ENCCHAR	11116	?

//! CVS version of the file (leave set to $Id: language.pl,v 1.11.2.1 2001/07/10 17:49:34 kiwi Exp $ if you don't use CVS)
//#ORIG $Id: language.pl,v 1.11.2.1 2001/07/10 17:49:34 kiwi Exp $
#define	TS_CVSVER	11117	$Id: language.pl,v 1.11.2.1 2001/07/10 17:49:34 kiwi Exp $

//! The copyright string put in the target .pike file
//#ORIG 2000 The Caudium Group
#define	TS_COPYRIGHT	11118	2000 The Caudium Group


// CAMAS Messages

//#ORIG Done
#define	M_SPELLDONE	Gotowe

//#ORIG anywhere
#define	M_SEARCHANYWHERE	gdziekolwiek

//#ORIG Cancel
#define	M_CANCELSEND	Anuluj

//#ORIG Drafts
#define	M_BOXDRAFTS	Szkice

//#ORIG Mailbox (m/r/u/s)
#define	M_MBOXNAME	Skrzynka (m/r/u/s)

//#ORIG Info
#define	M_INFO	Informacja

//#ORIG Subject
#define	M_SUBJECT	Temat

//#ORIG Save draft
#define	M_SAVEDRAFT	Zapisz szkic

//#ORIG From preferences
#define	M_SAVEDUSERINTERFACE	Z ustawie

//#ORIG Mark at least one mailbox.
#define	M_MBOXMARKONE	Zaznacz co najmniej jedn skrzynk

//#ORIG \#sprintf("[Next %d >>]", @arg)
#define	M_FORWARDN	\#sprintf("[Nastpne %d >>]", @arg)

//#ORIG Show full headers
#define	M_SHOWFULLHEADERS	Poka wszystkie nagwki

//#ORIG Edit the filter
#define	M_EDITFILTER	Edytuj filtr

//#ORIG \#sprintf("You have %d Kb available for upload.",@arg)
#define	M_AVAILSPACE	\#sprintf("Masz %d Kb miejsca dla zaadowania plikw.",@arg)

//#ORIG Inactive logout (minutes)
#define	M_PINACTIVELOGOUT	Automatyczne wylogowanie (minuty)

//#ORIG Delay
#define	M_DELAY	Delay

//#ORIG Logout
#define	M_LOGOUT	Wyloguj

//#ORIG Common addresses:
#define	M_GLOBALADDRESSES	Adresy wsplne:

//#ORIG Index filter (click to edit)
#define	M_INDEXNAMEEDITFILTER	Filtr indeksu (kliknij by edytowa)

//#ORIG Upload attachment
#define	M_UPLOADATTACHMENT	Zaaduj zacznik

//#ORIG \#sprintf ("%s requested a receipt to be returned. Do you wish to send one ?", @arg)
#define	M_NOTIFYTO	\#sprintf ("%s zada potwierdzenia odbioru wiadomoci. Czy zgadzasz si na wysanie potwierdzenia?", @arg)

//#ORIG Date
#define	M_DATE	Data

//#ORIG Address
#define	M_ADDRESS	Adres

//#ORIG Delete address
#define	M_DELETEADDRESS	Usu adres

//#ORIG \#sprintf("Find mail in mailbox <strong>%s</strong> which contains",arg[0])
#define	M_SEARCHMAILBOX	\#sprintf("Znajd w skrzynce <strong>%s</strong> wiadomo zawierajc",arg[0])

//#ORIG Mark all
#define	M_MARKALL	Zaznacz wszystko

//#ORIG Check inboxes
#define	M_CHECKACTIVEMAILBOXES	Sprawd skrzynki

//#ORIG You must select a mailbox to rename and supply a new name.
#define	M_NOMBOXERROR	Musisz zaznaczy skrzynk, ktrej nazw chcesz zmieni i poda now nazw

//#ORIG Suggestions
#define	M_SPELLSUGGESTIONS	Podpowiedzi

//#ORIG M
#define	M_MARKFLAG	Z

//#ORIG No addresses
#define	M_NOADDRESSES	Brak adresw

//#ORIG Default Bcc address
#define	M_PDEFAULTBCC	Domylny adres Bcc

//#ORIG Are you sure you want to delete the following mailboxes?
#define	M_MBOXREMOVEP	Czy jeste pewien, e chcesz usun ponisze skrzynki?

//#ORIG <b>You have been logged out.</b> Close this browser window to make sure no one can read your mail.<br /><br />Reload this page to login.
#define	M_LOGOUTMSG	<strong>Zostae wylogowany.</strong> Zamknij okienko przegldarki by upewni si, i nikt nie bdzie mg przeczyta Twojej poczty.<br /><br /> Przeaduj t stron by zalogowa si ponownie..

//#ORIG Delete marked
#define	M_DELETEMARKEDFILES	Usu zaznaczone

//#ORIG Save a copy
#define	M_SAVEMAILCOPY	Zapisz kopi

//#ORIG Extra headers
#define	M_PHEADER	Dodatkowe nagwki

//#ORIG Mail notification...
#define	M_MAILNOTIFYWINDOW	Powiadomienie o poczcie...

//#ORIG Index field (click to select a field)
#define	M_INDEXNAMEFIELDFILTER	Pole indeksu (kliknij by wybra pole)

//#ORIG Preferences
#define	M_PREFS	Waciwoci

//#ORIG Type
#define	M_MIMETYPE	Typ

//#ORIG \#sprintf("[<< Prev %d]", @arg)
#define	M_BACKN	\#sprintf("[<< Poprzednie %d]", @arg)

//#ORIG Continue...
#define	M_CONTINUECOMPOSE	Kontynuuj...

//#ORIG Time
#define	M_TIME	Czas

//#ORIG Address(es), comma separated
#define	M_ADDRESSFORMAT	Adres(y), rozdzielone przecinkami

//#ORIG Add attachment...
#define	M_ADDATTACHMENT	Dodaj zacznik...

//#ORIG Failed to rename mailbox. The name may be illegal or the mailbox may exist.
#define	M_RENAMEMBOXERROR	Prba zmiany nazwy skrzynki nie powioda si. Nazwa moe by nieprawidowa lub skrzynka moe ju istnie.

//#ORIG Current Mailbox
#define	M_CURRMAILBOX	Aktywna Skrzynka

//#ORIG There was a problem talking to the outgoing mail (SMTP) server, and the mail was not sent. The recipient of the mail might not exist.
#define	M_SMTPERROR	Wystpi problem w komunikacji z serwerem poczty wychodzcej (SMTP)\ni poczta nie zostaa wysana. Adresat poczty moe by nieprawidowy.

//#ORIG Forward
#define	M_FORWARD	Przelij dalej

//#ORIG Change to
#define	M_SPELLCHANGETO	Zmien na

//#ORIG Index filter
#define	M_INDEXNAMEFILTER	Filtr indeksu

//#ORIG Signature
#define	M_PSIGNATURE	Podpis

//#ORIG Search name containing:
#define	M_NAMECONT	Znajd nazw zawierajc:

//#ORIG Showing mail with\s
#define	M_SEARCHSHOWINGMAIL	Pokazywane wiadomoci z\s

//#ORIG Mail
#define	M_MAIL	Poczta

//#ORIG Bcc
#define	M_BCC	Bcc

//#ORIG [No mail]
#define	M_NOMAILS	[Brak poczty]

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENT	Nazwa indeksu (kliknij by doda jako adresata)

//#ORIG Cancel
#define	M_DIALOGCANCEL	Anuluj

//#ORIG Drafts folder
#define	M_PDRAFTSFOLDER	Folder szkicw

//#ORIG Rename a mailbox
#define	M_RENAMEMBOX	Zmie nazw skrzynki

//#ORIG Sent mail folder
#define	M_PSENTFOLDER	Folder poczty wysanej

//#ORIG There was a problem talking to the mail (IMAP) server.<br>Please contact the administrator.
#define	M_IMAPERROR	Wystpi problem komunikacji z serwerem pocztowym (IMAP).\nProsz skontaktowa si z administratorem.

//#ORIG Back
#define	M_MAILMISSINGBACK	Powrt

//#ORIG \#sprintf("Mail %d-%d of %d", @arg)
#define	M_MAILSHOWN	\#sprintf("Wiadomo %d-%d z %d", @arg)

//#ORIG OK
#define	M_DIALOGOK	OK

//#ORIG Report successful delivery.
#define	M_DSN_SUCCESS	Potwierd dostarczenie poczty

//#ORIG Wrong login or password. Try again.
#define	M_LOGINERROR	Nieprawidowy login lub haso. Sprbuj ponownie.

//#ORIG User interface
#define	M_PUSERINTERFACE	Interfejs uytkownika

//#ORIG Prefix
#define	M_PQUOTEPREFIX	Przedrostek

//#ORIG Edit filter
#define	M_EDITADDRESSFILTER	Edytuj filtr

//#ORIG (Select a field)
#define	M_SELECTFIELD	(Wybierz pole)

//#ORIG Language
#define	M_PLANGUAGE	Jzyk

//#ORIG No
#define	M_NO	Nie

//#ORIG \#sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg)
#define	M_CHARSETWARNING	\#sprintf("Uwaga! Nie mona odkodowa zestawu znakw \"%s\". Wiadomo jest wywietlana w postaci zakodowanej.",@arg)

//#ORIG Cc
#define	M_CC	Cc

//#ORIG Index name
#define	M_INDEXNAME	Nazwa indeksu

//#ORIG Add file as an attachment
#define	M_ADDFILEASATTACHMENT	Dodaj jako zacznik

//#ORIG <strong>Error:</strong> Failed to fetch mail. The mail might have a faulty format.<br />
#define	M_MAILMISSING	<strong>Bd:</strong> Prba cignicia wiadomoci nie powioda si. Wiadomo moe mie zy format.<br />

//#ORIG Compose mail
#define	M_COMPOSEMAIL	Nowa wiadomo

//#ORIG Sent
#define	M_BOXSENTMAIL	Wysane

//#ORIG Organization
#define	M_PORGANIZATION	Organizacja

//#ORIG Show text messages
#define	M_PSHOWTEXT	Pokazuj wiadomoci tekstowe

//#ORIG \#sprintf ("The mail \"%s\" was sent to: %s", @arg)
#define	M_SMTPOK	\#sprintf ("Wiadomo \"%s\" zostaa wysana do: %s", @arg)

//#ORIG Upload and import
#define	M_UPLOADANDIMPORT	Zaaduj i importuj

//#ORIG AND
#define	M_SEARCHAND	ORAZ

//#ORIG New filter...
#define	M_NEWADDRESSFILTER	Nowy filtr...

//#ORIG Yes
#define	M_YES	Tak

//#ORIG Sunday
#define	M_SUNDAY	niedziela

//#ORIG Move to trash
#define	M_MOVETHISTOTRASH	Przesu do kosza

//#ORIG To
#define	M_TO	Do

//#ORIG in the mail body
#define	M_SEARCHBODY	w tekcie wiadomoci

//#ORIG Empty the trash folder
#define	M_DELETEALLTRASH	Oprnij kosz

//#ORIG Index name (click to edit)
#define	M_INDEXNAMEEDIT	Nazwa indeksu (kliknij by edytowa)

//#ORIG \#sprintf("%sattachment of type %s",@arg)
#define	M_ATTACHMENTLINK	\#sprintf("%szacznik typu %s",@arg)

//#ORIG Check for new mail
#define	M_CHECKNEWMAIL	Sprawd poczt

//#ORIG Mailboxes
#define	M_MAILBOXES	Skrzynki

//#ORIG Trash
#define	M_BOXTRASH	Kosz

//#ORIG Trash folder
#define	M_PTRASHFOLDER	Kosz

//#ORIG Include mail when replying
#define	M_PINCLUDEMAIL	Docz orygina do odpowiedzi

//#ORIG \#sprintf ("<b>Could not log in:</b> %s", @arg)
#define	M_NOLOGIN	<strong>Zalogowanie niemoliwe:</strong>

//#ORIG Index field
#define	M_INDEXFIELDFILTER	Pole indeksu

//#ORIG Upload
#define	M_UPLOAD	Zaaduj

//#ORIG Include attachments
#define	M_PSAVEATTACHMENTS	Razem z zacznikami

//#ORIG Back to compose
#define	M_BACKTOCOMPOSE	Powrt do edycji

//#ORIG Save and use
#define	M_SAVEADDRESS	Zapisz i uyj

//#ORIG No attachments
#define	M_NOATTACHMENTS	Brak zacznikw

//#ORIG Path
#define	M_FOLDER_PATH	cieka

//#ORIG \#([ "forward": "forward", "backward":"backward"])[arg[0]]
#define	M_PSORTORDERS	\#([ "forward": "w przd", "backward":"w ty"])[arg[0]]

//#ORIG Read next
#define	M_READNEXT	Czytaj nastpn

//#ORIG Add recipients
#define	M_ADDRECIPIENTS	Dodaj adresatw

//#ORIG Default addressbook (not extended)
#define	M_PADDRESSBOOK	Domylna ksika adresowa (nierozszerzona)

//#ORIG Password:
#define	M_PASSWORD	Haso:

//#ORIG Cancel
#define	M_CANCELADDRESSFILTER	Anuluj

//#ORIG Import address book...
#define	M_IMPORTADDRESSBOOK	Importuj ksik adresow...

//#ORIG No filter
#define	M_NOADDRESSESFILTER	Brak filtru

//#ORIG Return Receipt (displayed) -\s
#define	M_MDNHEADER	Potwierdzenie Odbioru (wywietlane) -\s

//#ORIG Reply to all
#define	M_REPLYTOALL	Odpowiedz wszystkim

//#ORIG From
#define	M_FROM	Od

//#ORIG in subject
#define	M_SEARCHSUBJECT	w temacie

//#ORIG Move marked to trash
#define	M_MOVETOTRASH	Przesu zaznaczone do kosza

//#ORIG Address Book
#define	M_ADDRESSBOOKTITLE	Ksika Adresowa

//#ORIG Saturday
#define	M_SATURDAY	sobota

//#ORIG Select a mailbox
#define	M_SELECTMBOX	Wybierz skrzynk

//#ORIG \#sprintf("Mailbox: %s",@arg)
#define	M_MAILBOX	\#sprintf("Skrzynka: %s",@arg)

//#ORIG Report delayed delivery.
#define	M_DSN_DELAY	Powiadom o opnionym dostarczeniu

//#ORIG Mail searchpath
#define	M_PMAILPATH	cieka wyszukiwania poczty

//#ORIG Enable <em>\"Show full headers\"</em>-button
#define	M_PSHOWHIDDENHEADERS	Uaktywnij przycisk <em>\"Poka wszystkie nagwki\"</em>

//#ORIG Delete filter
#define	M_DELETEADDRESSFILTER	Usu filtr

//#ORIG Send
#define	M_SEND	Wylij

//#ORIG Size
#define	M_SIZE	Rozmiar

//#ORIG The Pine address book is often in ~/.addressbook
#define	M_PINELOCATION	Ksika adresowa Pine czsto znajduje si w ~/.addressbook

//#ORIG Upload to attachments
#define	M_UPLOADTOATTACHMENTS	Dodaj do zacznikw

//#ORIG #
#define	M_NUMBER	#

//#ORIG Add to address book
#define	M_ADDADDRESS	Dodaj do ksiki adresowej

//#ORIG \#sprintf("This is a Return Receipt for the mail that you sent to %s.Note: this Return Receipt only acknowledges that the message was displayed on the recipient's machine. There is no guarantee that the content has been read or understood.", @arg)
#define	M_MDNMESSAGE	\#sprintf("Potwierdzenie Odbioru poczty, ktr wysae do %s. Uwaga: niniejsze Potwierdzenie Odbioru jest jedynie sygnaem, i wiadomo zostaa <strong>wywietlona</strong> na ekranie komputera adresata. Nie ma gwarancji, e zawarto zostaa przeczytana i/lub zrozumiana.", @arg)

//#ORIG Do not save this mail
#define	M_DONTSAVEMAIL	Nie zapisuj tej wiadomoci

//#ORIG Thursday
#define	M_THURSDAY	czwartek

//#ORIG Mail sort order
#define	M_PSORTORDER	Porzdek sortowania

//#ORIG Read previous
#define	M_READPREV	Czytaj poprzedni

//#ORIG [Previous level]
#define	M_PREVIOUS_LEVEL	[Poprzedni poziom]

//#ORIG End this CAMAS session ?
#define	M_ENDSESSION	Zakoczy t sesj z CAMAS ?

//#ORIG You must specify a recipient of the mail.
#define	M_SENDNORECV	Musisz poda adresata.

//#ORIG Search...
#define	M_SEARCHMAIL	Szukaj...

//#ORIG Files
#define	M_FILES	Pliki

//#FLAG <changed>
//#ORIG Upload a Pine, exported Netscape (.ldif) or Outlook (.csv) address book
#define	M_UPLOADADDRESSBOOK	Zaaduj ksik adresow Pine lub wyeksportowan ksik Netscape (.ldif)

//#ORIG Folder
#define	M_ADDRESSFILTER	Folder

//#ORIG Monday
#define	M_MONDAY	poniedziaek

//#ORIG Report delivery
#define	M_MDN	Potwierd dostarczenie

//#ORIG (Name)
#define	M_NEWMBOXNAME	(Nazwa)

//#ORIG Mail is too big to be shown. Click here to download it.
#define	M_MAILTOOBIG	Wiadomo jest zbyt dua by j pokaza. Kliknij tutaj by j cign.

//#ORIG in the 'to' field
#define	M_SEARCHTOFIELD	w polu 'Do'

//#ORIG Change sort order
#define	M_CHANGESORTORDER	Zmie porzdek sortowania

//#ORIG Address book...
#define	M_ADDRESSBOOK	Ksika adresowa...

//#ORIG Move marked to
#define	M_MOVEMARKED	Przesu zaznaczone do

//#ORIG Compose
#define	M_NEWMAIL	Nowa wiadomo

//#ORIG Failed to create mailbox. The name may be illegal or the mailbox may exist.
#define	M_CREATEMBOXERROR	Nie mona utworzy skrzynki. Nazwa moe by nieprawidowa lub skrzynka moe ju istnie.

//#ORIG You have no uploaded files
#define	M_NOFILES	Nie masz adnych zaadowanych plikw

//#ORIG Show HTML messages
#define	M_PSHOWHTML	Pokazuj wiadomoci HTML

//#ORIG Attachments
#define	M_ATTACHMENTSHEADER	Zaczniki

//#ORIG Search LDAP
#define	M_SEARCHLDAP	Przeszukuj LDAP

//#ORIG Save and use
#define	M_SAVEADDRESSFILTER	Zapisz i uyj

//#ORIG OU
#define	M_OU	OU

//#ORIG Index folder
#define	M_FILTERFOLDER	Folder indeksu

//#ORIG Today
#define	M_TODAY	dzi

//#ORIG Add marked to attachments
#define	M_ADDMARKEDTOATTACHMENTS	Dodaj zaznaczone do zacznikw

//#ORIG Hide full headers
#define	M_HIDEFULLHEADERS	Ukryj dodatkowe nagwki

//#ORIG Edit address
#define	M_EDITADDRESS	Edytuj adres

//#ORIG Spell check
#define	M_SPELLCHECK	Sprawd pisowni

//#ORIG A
#define	M_ANSWEREDFLAG	O

//#ORIG Wednesday
#define	M_WEDNESDAY	roda

//#ORIG OK
#define	M_LOGIN_OK	OK

//#ORIG Messages shown in a mailbox
#define	M_PVISIBLEMESSAGES	Wiadomoci wywietlane

//#ORIG Question
#define	M_QUESTION	Pytanie

//#ORIG Default filterbook (not extended)
#define	M_PADDRESSBOOKFILTER	Domylny zestaw filtrw (nierozszerzony)

//#ORIG Search mail
#define	M_SEARCHMAILTITLE	Przeszukaj poczt

//#ORIG Add to filter book
#define	M_ADDADDRESSFILTER	Dodaj do zestawu filtrw

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOKTITLE	Importuj ksik adresow

//#ORIG LDAP search
#define	M_LDAP	Wyszukiwanie w LDAP

//#ORIG Create a new mailbox
#define	M_CREATEMBOX	Utwrz now skrzynk

//! Label on the login screen
//#ORIG Login:
#define	M_LOGIN	Login:

//#ORIG Delete
#define	M_DELETE	Usu

//#ORIG Next
#define	M_SPELLNEXT	Nastpny

//#ORIG in the 'from' field
#define	M_SEARCHFROMFIELD	w polu 'Od'

//#ORIG Please mark some messages first.
#define	M_DELETEMARKEDNONE	Zaznacz uprzednio kilka wiadomoci.

//#ORIG Name
#define	M_PNAME	Nazwa

//#ORIG N
#define	M_NEWFLAG	N

//#ORIG Tuesday
#define	M_TUESDAY	wtorek

//#ORIG Logged out
#define	M_LOGGEDOUT	Wylogowany

//#ORIG \#sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0])
#define	M_SENDBROKENADDR	\#sprintf("Adres \"%s\" nie jest prawidowym adresem email. Popraw go i sprbuj ponownie.", arg[0])

//#ORIG User interface:
#define	M_USERINTERFACE	Interfejs uytkownika:

//#ORIG Type in a name first.
#define	M_NEWMBOXNONAME	Podaj nazw

//#ORIG You must specify non-empty index folder and filter(s).
#define	M_EMPTYADDRESSFILTER	Musisz wskaza folder indeksw oraz filtr(y).

//#ORIG Mail was sent successfully, but save in folder failed.
#define	M_SENDSAVEFAILED	Poczta zostaa wysana prawidowo, lecz zapis do folderu nie powid si.

//#ORIG Mail address
#define	M_PMAILADDRESS	Adres pocztowy

//#ORIG Sort on column
#define	M_PSORTCOLUMN	Sortuj wg kolumny

//#ORIG Mail Filter
#define	M_FILTERBOOKTITLE	Filtr Poczty

//#ORIG Inbox
#define	M_INBOX	Skrzynka gwna

//#ORIG Cannot import this addressbook, since its\nformat is not recognized.
#define	M_CANNOTIMPORT	Nie mona zaimportowa tej ksiki adresowej gdy\njej format jest nieznany.

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENTFILTER	Nazwa indeksu (kliknij by doda jako adresata)

//#ORIG Remove marked attachments
#define	M_REMOVEMARKEDATTACHMENTS	Usu zaznaczone zaczniki

//#ORIG Delete marked
#define	M_DELETEMARKEDMBOX	Usu zaznaczone

//#ORIG Previous
#define	M_SPELLPREV	Poprzedni

//#ORIG New address
#define	M_NEWADDRESS	Nowy adres

//#ORIG \#sprintf("Are you sure you want to delete the %d marked message(s)?", @arg)
#define	M_DELETEMARKEDP	\#sprintf("Czy jeste pewien, e chcesz usun %d zaznaczonych odpowiedzi?", @arg)

//#ORIG Select files to send. Press 'Ctrl' to toggle-select multiple files.
#define	M_SENDMOREFILES	Zaznacz pliki do wysania. Wcinij 'Ctrl' by zaznaczy wicej ni jeden plik.

//#ORIG Filename
#define	M_FILENAME	Nazwa pliku

//#ORIG Reply
#define	M_REPLY	Odpowiedz

//#ORIG Attachments
#define	M_ATTACHMENTS	Zaczniki

//#ORIG Save and use
#define	M_PSAVEANDUSE	Zapisz i uyj

//#ORIG Delete marked
#define	M_DELETEMARKED	Usu zaznaczone

//#ORIG Windows users: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.
#define	M_WINDOWSBUG	Z powodu bdu niektrych przegldarek WWW, nazwy plikw mog by nieprawidowe. Mona tego unikn zastpujc kocowy znak \\ znakami \\\\ przed klikniciem przycisku 'Wylij'.

//#ORIG (Lines with headers in this format: header:value)
#define	M_PHEADERDESC	(Linie w formacie: nagwek:warto)

//#ORIG No files
#define	M_NOATTACHFILES	Brak plikw

//#ORIG LDAP addresses
#define	M_LDAPTITLE	Adresy LDAP

//#ORIG Get new mail...
#define	M_GETNEWMAIL	Odbierz now poczt...

//#ORIG Index field
#define	M_INDEXNAMEEDITFIELDFILTER	Pole indeksu

//#ORIG Cancel
#define	M_CANCELADDRESS	Anuluj

//#ORIG Filters
#define	M_FILTERBOOK	Filtry

//#ORIG Friday
#define	M_FRIDAY	pitek

