#!/bin/sh -
#	$OpenBSD: lorder.sh,v 1.7 1997/01/25 21:16:44 deraadt Exp $
#	$NetBSD: lorder.sh,v 1.3 1995/04/24 07:38:52 cgd Exp $
#
# Copyright (c) 1990, 1993
#	The Regents of the University of California.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by the University of
#	California, Berkeley and its contributors.
# 4. Neither the name of the University nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
#	@(#)lorder.sh	8.1 (Berkeley) 6/6/93
#

# only one argument is a special case, just output the name twice
case $# in
	0)
		echo "usage: lorder file ...";
		exit ;;
	1)
		echo $1 $1;
		exit ;;
esac

# temporary files
TDIR=/tmp/_lorder$$
R=$TDIR/reference
S=$TDIR/symbol

um=`umask`
umask 022
if ! mkdir $TDIR ; then
	echo temporary directory exists $TDIR
	exit 1
fi
umask $um

# remove temporary files on HUP, INT, QUIT, PIPE, TERM
trap "rm -rf $TDIR; exit 1" HUP INT QUIT PIPE TERM

# if the line ends in a colon, assume it's the first occurrence of a new
# object file.  Echo it twice, just to make sure it gets into the output.
#
# if the line has " T " or " D " it's a globally defined symbol, put it
# into the symbol file.
#
# if the line has " U " it's a globally undefined symbol, put it into
# the reference file.
#
# The awk nastyness is to rearrange the output of GNU nm to be more to the
# seddery's liking.
if nm --version 2>/dev/null | grep -q GNU; then
  FILT='BEGIN{FS="[: ]"}{if (seen[$1]) print $0; else print $1 ":"; print $0; seen[$1]=1}'
else
  FILT='{print $0}'
fi

${NM:-nm} -go $* | awk "$FILT" | sed "
	/:$/ {
		s/://
		s/.*/& &/
		p
		d
	}
	/ [TD] / {
		s/:.* [TD] / /
		w $S
		d
	}
	/ U / {
		s/:.* U / /
		w $R
	}
	d
"

# sort symbols and references on the first field (the symbol)
# join on that field, and print out the file names.
sort -k 2 -o $R $R
sort -k 2 -o $S $S
join -j 2 -o 1.1 2.1 $R $S
rm -rf $TDIR
