
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * This will be a simple pushbutton, initially it will function as 2 throw,
 * but may incorporate capabilities to support pure contact switches.
 * radio buttons will probably have to be separate.
 */

#include <math.h>

#include "brightoninternals.h"

int
destroyButton(brightonDevice *dev)
{
	printf("destroyButton()\n");

	if (dev->image)
		brightonFreeBitmap(dev->bwin, dev->image);
	dev->image = NULL;
}

static int
displaybutton(brightonDevice *dev)
{
	int flags = 0;

	if (dev->bwin->app->resources[dev->panel].flags & BRIGHTON_WITHDRAWN)
		return;

	brightonDevUndraw(dev->bwin, dev->bwin->dlayer,
		dev->x + dev->bwin->app->resources[dev->panel].sx,
		dev->y + ((int) dev->lastposition)
			+ dev->bwin->app->resources[dev->panel].sy,
		dev->width, dev->height / 4);

	if (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
		& BRIGHTON_THREEWAY)
	{
		if (dev->value == 0)
		{
			brightonStretch(dev->bwin, dev->imagec,
				dev->bwin->dlayer,
				dev->x + dev->bwin->app->resources[dev->panel].sx,
				dev->y + dev->bwin->app->resources[dev->panel].sy,
				dev->width, dev->height, flags);
		} else if (dev->value == 1) {
			brightonStretch(dev->bwin, dev->image2,
				dev->bwin->dlayer,
				dev->x + dev->bwin->app->resources[dev->panel].sx,
				dev->y + dev->bwin->app->resources[dev->panel].sy,
				dev->width, dev->height, flags);
		} else if (dev->value == 2) {
			brightonStretch(dev->bwin, dev->image,
				dev->bwin->dlayer,
				dev->x + dev->bwin->app->resources[dev->panel].sx,
				dev->y + dev->bwin->app->resources[dev->panel].sy,
				dev->width, dev->height, flags);
		}
	} else if (dev->image2) {
		if (dev->value)
			brightonStretch(dev->bwin, dev->image2,
				dev->bwin->dlayer,
				dev->x + dev->bwin->app->resources[dev->panel].sx,
				dev->y + dev->bwin->app->resources[dev->panel].sy,
				dev->width, dev->height,
				dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags);
		else
			brightonStretch(dev->bwin, dev->image,
				dev->bwin->dlayer,
				dev->x + dev->bwin->app->resources[dev->panel].sx,
				dev->y + dev->bwin->app->resources[dev->panel].sy,
				dev->width, dev->height,
				dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags);
	} else {
		if ((~dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
			& BRIGHTON_CHECKBUTTON))
		{
			if (dev->value == 0)
				flags = 0;
			else
				flags = BRIGHTON_REVERSE|BRIGHTON_HALF_REVERSE;
	
			flags |= (BRIGHTON_VERTICAL
				& dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags);
		}

		brightonStretch(dev->bwin, dev->image,
			//dev->bwin->app->resources[dev->panel].canvas,
			dev->bwin->dlayer,
			dev->x + dev->bwin->app->resources[dev->panel].sx,
			dev->y + dev->bwin->app->resources[dev->panel].sy,
			dev->width, dev->height, flags);
	}

	brightonFinalRender(dev->bwin,
		dev->x + dev->bwin->app->resources[dev->panel].sx,
		dev->y + dev->bwin->app->resources[dev->panel].sy,
		dev->width, dev->height);

	dev->lastvalue = dev->value;
	dev->lastposition = dev->position;
}

/*
 * This will go into brighton render
 */
static int
renderHighlights(brightonWindow *bwin, brightonDevice *dev)
{
	float d, streak, dx, dy;
	brightonCoord p[8];

	if (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags &
		(BRIGHTON_CHECKBUTTON|BRIGHTON_NOSHADOW))
		return;

	dx = dev->x - bwin->lightX;
	dy = dev->y - bwin->lightY;

	d = sqrt((double) (dx * dx + dy * dy));

	streak = (dev->width * 2.0 * d / bwin->lightH)
		/ (1 - dev->width * 2.0 / bwin->lightH);

	p[0].x = dev->x;
	p[0].y = dev->y + dev->height;
	p[1].x = dev->x + dev->width;
	p[1].y = dev->y;
	p[2].x = dev->x + dx * streak / d;
	p[2].y = dev->y + dy * streak / d;

//	XFillPolygon(bwin->display, bwin->background, bwin->cheap_shade,
//		(XPoint *) &p, 3, Complex, CoordModeOrigin);
}

static int considercallback(brightonDevice *dev)
{
	brightonIResource *panel = &dev->bwin->app->resources[dev->panel];

	if ((dev->lastvalue != dev->value)
			|| (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags &
	        BRIGHTON_CHECKBUTTON))
	{
		if (panel->devlocn[dev->index].callback)
		{
			panel->devlocn[dev->index].callback(dev->bwin, dev->panel,
				dev->index, dev->value);
		} else {
			if (panel->callback)
				panel->callback(dev->bwin, dev->panel, dev->index, dev->value);
		}
	}
}

static int
configure(brightonDevice *dev, brightonEvent *event)
{
//	printf("configureButton(%i, %f)\n", dev->index, dev->value);

	if (event->command == -1)
		return(-1);

	if (event->command == BRIGHTON_RESIZE)
	{
		dev->x = event->x;
		dev->y = event->y;
		dev->width = event->w;
		dev->height = event->h;
		/*
		 * We should consider altering the locations structure, so that
		 * event dispatching is correct.
		 */
		if ((dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
			& BRIGHTON_CHECKBUTTON) == 0)
			considercallback(dev);

		brightonPanelLocation(dev->bwin,
			dev->panel, dev->index, dev->x, dev->y, dev->width, dev->height);

		/*
		 * We need to build in some shadow, to prevent the button from looking
		 * like it is hanging in mid air.
		 */
		renderHighlights(dev->bwin, dev);

		dev->lastvalue = -1;
		displaybutton(dev);

		return(0);
	}

	if (event->command == BRIGHTON_LEAVE)
	{
		if (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
			& BRIGHTON_CHECKBUTTON)
		{
			dev->value = 0;

			displaybutton(dev);
		}
		return(0);
	}

	if (event->command == BRIGHTON_ENTER)
	{
		if (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
			& BRIGHTON_CHECKBUTTON)
		{
			dev->value = 1;

			displaybutton(dev);
		}
		return(0);
	}

	if (event->command == BRIGHTON_BUTTONRELEASE)
	{
		if (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
			& BRIGHTON_CHECKBUTTON)
		{
			dev->value = 0;

			displaybutton(dev);

			considercallback(dev);
		}
		return(0);
	}

	if (event->command == BRIGHTON_BUTTONPRESS)
	{
		brightonIResource *panel = &dev->bwin->app->resources[dev->panel];
/*
		if (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
			& BRIGHTON_CHECKBUTTON)
			return(0);
*/
		if (dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags &
			BRIGHTON_THREEWAY)
		{
			if (--dev->value < 0)
				dev->value = 2;
		} else if (dev->value == 0)
			dev->value = panel->devlocn[dev->index].to;
		else
			dev->value = panel->devlocn[dev->index].from;

		if ((dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
			& BRIGHTON_CHECKBUTTON) == 0)
			considercallback(dev);

		displaybutton(dev);

		return(0);
	}

	if (event->command == BRIGHTON_KEYPRESS)
	{
		brightonIResource *panel = &dev->bwin->app->resources[dev->panel];

		if (event->key == 65)
		{
			if (dev->value == 0)
				dev->value = panel->devlocn[dev->index].to;
			else
				dev->value = panel->devlocn[dev->index].from;
		}
		considercallback(dev);

		displaybutton(dev);
	}

	if (event->command == BRIGHTON_PARAMCHANGE)
	{
		dev->value = event->value;
		dev->lastvalue = -1;

		if ((dev->bwin->app->resources[dev->panel].devlocn[dev->index].flags
			& BRIGHTON_CHECKBUTTON) == 0)
			considercallback(dev);

		displaybutton(dev);

		return(0);
	}
}

int *
createButton(brightonWindow *bwin, brightonDevice *dev, int index, char *bitmap)
{
	brightonIResource *panel = &bwin->app->resources[dev->panel];

	//printf("createButton(%s, %x)\n", bitmap, panel->devlocn[dev->index].image);

	dev->destroy = destroyButton;
	dev->configure = configure;
	dev->bwin = bwin;

	if (bwin->app->resources[dev->panel].devlocn[dev->index].flags
		& BRIGHTON_THREEWAY)
	{
		if (dev->image)
			brightonFreeBitmap(bwin, dev->image);
		if (dev->image2)
			brightonFreeBitmap(bwin, dev->image2);
		if (dev->imagec)
			brightonFreeBitmap(bwin, dev->imagec);

		dev->image =
			brightonReadImage(bwin, "bitmaps/buttons/sw5.xpm");
		dev->image2 =
			brightonReadImage(bwin, "bitmaps/buttons/sw4.xpm");
		dev->imagec =
			brightonReadImage(bwin, "bitmaps/buttons/sw3.xpm");
	} else if (bitmap == NULL) {
		if (dev->image)
			brightonFreeBitmap(bwin, dev->image);
		/*
		 * If we have been passed a specific image name for this device then
		 * use it.
		 */
		if (panel->devlocn[dev->index].image != 0)
			dev->image =
				bwin->app->resources[dev->panel].devlocn[dev->index].image;
		else
			dev->image = brightonReadImage(bwin,
				"bitmaps/buttons/rockerred.xpm");
		if (panel->devlocn[dev->index].image2 != 0)
			dev->image2 =
				bwin->app->resources[dev->panel].devlocn[dev->index].image2;
		else
			dev->image =
				brightonReadImage(bwin, "bitmaps/buttons/rockerred.xpm");
	} else {
		if (dev->image)
			brightonFreeBitmap(bwin, dev->image);

		if (panel->devlocn[dev->index].image != 0)
			dev->image =
				bwin->app->resources[dev->panel].devlocn[dev->index].image;
		else
			dev->image = brightonReadImage(bwin, bitmap);

		if (dev->image2)
			brightonFreeBitmap(bwin, dev->image2);

		if (panel->devlocn[dev->index].image2 != 0)
			dev->image2 =
				bwin->app->resources[dev->panel].devlocn[dev->index].image2;
	}

	/*
	 * These will force an update when we first display ourselves.
	 */
	dev->value = 0;
	dev->lastvalue = -1;
	dev->lastposition = -1;

	return(0);
}

