// *************************************************************************
//
// Copyright (C) 2004-2006 Bruno PAGES  All rights reserved.
//
// This file is part of the BOUML Uml Toolkit.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// e-mail : bouml@free.fr
// home   : http://bouml.free.fr
//
// *************************************************************************

#ifndef UMLCLASS_H
#define UMLCLASS_H

#include "UmlBaseClass.h"

#ifdef REVERSE
#include <qstringlist.h>
#endif

class UmlFormalParameter : public UmlBaseFormalParameter {
  public:
    UmlFormalParameter(){};
    UmlFormalParameter(QCString n, const UmlTypeSpec & e);
};

typedef QValueList<UmlFormalParameter> FormalParameterList;

class UmlActualParameter : public UmlBaseActualParameter {
  public:
    UmlActualParameter(){};
};

class UmlClass : public UmlBaseClass {
  public:
    UmlClass(void * id, const QCString & n);
#ifdef REVERSE
    void need_artifact(const QStringList & imports,
		       const QStringList & static_imports,
		       UmlArtifact *& cp);
#endif
    static void manage_generic(QCString & form, UmlTypeSpec & typespec,
			       QCString str_actuals, const char * k);
};

#endif
