/***************************************************************************
                          dlgbrowsers.h  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGBROWSERS_H
#define DLGBROWSERS_H

#include <QDialog>

#include "ui_dlgbrowsers.h"
#include "bknode.h"

/***************************************************************************
 *                                                                         *
 *   The DlgBrowsers class represents a dialog box used to list the        *
 *   browsers supported by BookmarkBridge, allowing the user to pick one.  *
 *                                                                         *
 ***************************************************************************/

class DlgBrowsers : public QDialog, public Ui::DlgBrowsers
{
	Q_OBJECT;

public:
	DlgBrowsers(QWidget *parent=0);
	virtual ~DlgBrowsers();

	BRWSTYPE browser;	// BrowserNum of the currently selected browser

public slots:
	void on_listBrowsers_currentItemChanged(QListWidgetItem *item);

private:
	void    RefreshList(void);
};

#endif  // end of DLGBROWSERS_H
