// Main.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <unistd.h>
#include <iostream.h>
#include <stdio.h>
#include <signal.h>

#ifdef USESCRIPTS
extern "C" {
#include <guile/gh.h>
}
#include "Interp.H"
#endif

#include "Bot.H"

Bot *b;

void sig_hup(int) {
  if (b) {
    b->userList->read();
    b->userList->addUserFirst("bidon", "bidon", 0, 0, false, 0, "");
    b->reconnect();
  }
}

void printUsage(char *name)
{
  cout << "Usage: " << name << " [-h] [-b] [-f file] [-d dir] [-D]\n"
    " -h        Shows this help.\n"
    " -b        Do not run in background.\n"
    " -f file   Use file as config file.\n"
    " -d dir    Use dir as current dir.\n"
    " -D        Debug mode (input/output printing and no background mode.\n";
}

static void real_main(int argc, char **argv)
{
  int opt;
  extern char *optarg;
  bool background = true;
  String configFile = "bot.conf";
  String directory = "";
  bool debug = false;

  signal(SIGPIPE, SIG_IGN);
  signal(SIGALRM, SIG_IGN);
  signal(SIGHUP,  sig_hup);

  // We parse the command line options
  while ((opt = getopt(argc,argv,"hbf:d:D")) != EOF)
    switch (opt) {
    case 'h':
      printUsage(argv[0]); exit(0);
    case 'b':
      background = false;
      break;
    case 'f':
      configFile = optarg;
      break;
    case 'd':
      directory = optarg;
      break;
    case 'D':
      debug = true;
      break;
    default:
      printUsage(argv[0]); exit(1);
    }

  if ((directory != "") && (chdir((const char *)directory)<0))
    perror("Warning: ");

  cout << COPYRIGHT_STRING <<
    "\nBobot++ comes with ABSOLUTELY NO WARRANTY\n"
    "This is free software, and you are welcome to redistribute it\n"
    "under certain conditions; See the LICENSE file for details.\n";

  if (!debug) {
    if (background)
      switch (fork()) {
      case -1:
        cout << "Could not run in the background. Exiting...\n";
        perror("fork");
        exit(1);
      case 0:
        break;
      default:
        cout << "Running in the background...\n";
        exit(0);
      }
  }

#ifdef USESCRIPTS
  Interp::Startup();
#endif

  b = new Bot(configFile, debug);
  b->run();
  delete b;

#ifdef USESCRIPTS
  Interp::Shutdown();
#endif
}

int main(int argc, char **argv) {
#ifdef USESCRIPTS
  gh_enter(argc, argv, real_main);
#else
  real_main(argc, argv);
#endif

  return 0;
}
