/*  BMPx - The Dumb Music Player
 *  Copyright (C) 2005 BMPx development team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id$
 *
 * The BMPx project hereby grant permission for non-gpl compatible GStreamer
 * plugins to be used and distributed together with GStreamer and BMPx. This
 * permission are above and beyond the permissions granted by the GPL license
 * BMPx is covered by.
 *  $Id$
 */

/* For sigaction() and SA_RESTART */
#include <config.h>

#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <stdlib.h>

#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include "signals.hh"

#include "main.hh"
#include "x_service_core.hh"

#define SIGNAL_CHECK_INTERVAL 1000

namespace Signals
{
  namespace
  {
    typedef void (*SignalHandler) (gint);


    bool terminate = false;

    SignalHandler
    install_handler_full (gint           signal_number,
                          SignalHandler  handler,
                          gint          *signals_to_block,
                          gsize          n_signals)
    {
      struct sigaction action, old_action;
      gsize i;

      action.sa_handler = handler;
      action.sa_flags = SA_RESTART;

      sigemptyset (&action.sa_mask);

      for (i = 0; i < n_signals; i++)
        sigaddset (&action.sa_mask, signals_to_block[i]);

      if (sigaction (signal_number, &action, &old_action) == -1)
        {
          g_message ("Failed to install handler for signal %d", signal_number);
          return NULL;
        }

      return old_action.sa_handler;
    }

    /*
     * A version of signal() that works more reliably across different
     * platforms. It:
     * a. restarts interrupted system calls
     * b. does not reset the handler
     * c. blocks the same signal within the handler
     *
     * (adapted from Unix Network Programming Vol. 1)
     */
    static SignalHandler
    install_handler (gint          signal_number,
                     SignalHandler handler)
    {
      return install_handler_full (signal_number, handler, NULL, 0);
    }

    void
    empty_handler (gint signal_number)
    {
      /* empty */
    }

    void
    sigsegv_handler (gint signal_number)
    {
      g_printerr (_("BMPx has crashed. If you suspect a bug, please consult "
                    "http://bmpx.beep-media-player.org/site/Reporting_bugs\n"));

#ifdef HANDLE_SIGSEGV
      /* TODO: backup session, config and playlist */

      exit (EXIT_FAILURE);
#else
      abort ();
#endif
    }

    void
    sigterm_handler (gint signal_number)
    {
      terminate = TRUE;
    }

    gboolean
    process_signals (gpointer data)
    {
      if (terminate)
        {
          g_message (_("SIGTERM received, quitting."));

          if (startup)
            {
              exit (0);
            }
          else
            {
	            core->stop (); 
            }
          return FALSE;
        }

      return TRUE;
    }

  } // anonymous namespace

  void
  handlers_init ()
  {
    install_handler (SIGPIPE, empty_handler);
    install_handler (SIGSEGV, sigsegv_handler);
    install_handler (SIGINT, sigterm_handler);
    install_handler (SIGTERM, sigterm_handler);

    g_timeout_add (SIGNAL_CHECK_INTERVAL, process_signals, NULL);
  }

} // Signals
