//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_RESIZABLE_HH
#define BMP_RESIZABLE_HH

#include <gtkmm.h>
#include <libglademm.h>

namespace Bmp
{
  class Resizable : public Gtk::Alignment
  {
    public:

      typedef sigc::signal<void, int> SignalShrinkDelta;

    private :

      Gtk::StateType handle_state; 
      Glib::RefPtr<Gdk::Window> handle_window;
      bool moving;
      int  h_original;

      SignalShrinkDelta signal_shrink_delta_;

    public : 

      SignalShrinkDelta& signal_shrink_delta() { return signal_shrink_delta_; }

      Resizable (BaseObjectType                        *cobject,
                 const Glib::RefPtr<Gnome::Glade::Xml> &xml);
 
      virtual ~Resizable (); 

    protected :
      
      virtual void on_realize ();
      virtual void on_size_request (Gtk::Requisition * req);
      virtual void on_size_allocate (Gtk::Allocation & allocation);
      virtual bool on_enter_notify_event (GdkEventCrossing * event);
      virtual bool on_leave_notify_event (GdkEventCrossing * event);
      virtual bool on_button_press_event (GdkEventButton * event);
      virtual bool on_button_release_event (GdkEventButton * event);
      virtual bool on_motion_notify_event (GdkEventMotion * event);
      virtual bool on_expose_event (GdkEventExpose * event);
  };
}

#endif //!BMP_RESIZABLE_HH
