//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_DIALOG_PROGRESS_HH 
#define BMP_DIALOG_PROGRESS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>
#include <glibmm/markup.h>
#include <gtkmm.h>
#include <libglademm.h>

namespace Bmp
{
    class ProgressDialog : public Gtk::Dialog
    {
      public:

        ProgressDialog (BaseObjectType                       * obj,
                        Glib::RefPtr<Gnome::Glade::Xml> const& xml);
        static ProgressDialog * create ();
        ~ProgressDialog () {}

        void set_progress (guint64 n_items, guint64 nth_item);
        void add_file (bool ok, std::string const& name, std::string const& state = std::string());
        void done (guint64 n_items_added, guint64 n_items_total);

      private:

        class Columns : public Gtk::TreeModel::ColumnRecord
        {
          public:
        
            Gtk::TreeModelColumn<bool>               error;
            Gtk::TreeModelColumn<Glib::ustring>      state;
            Gtk::TreeModelColumn<Glib::ustring>      name;


            Columns ()
            {
              add (error);
              add (state);
              add (name);
            }

        };
        Columns columns;

        void cell_data_func_state (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& m_iter);

        // GladeXML Data
        Glib::RefPtr<Gnome::Glade::Xml>       m_ref_xml;
        Gtk::ProgressBar                    * m_progress;
        Gtk::TreeView                       * m_view;
        Glib::RefPtr<Gtk::ListStore>          m_store;
    };
}
#endif // !BMP_DIALOG_PROGRESS_HH
