//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glibmm.h>
#include <gtkmm.h>
#include <libglademm.h>
#include <glib/gstdio.h>

#include <cstring>
#include <iostream>
#include <sstream>
#include <string>

#include <boost/format.hpp>
#include <boost/optional.hpp>

#include "main.hh"
#include "paths.hh"

#include "util.hh"
#include "ui_toolbox.hh"
#include "uri++.hh"

#include "lyrics.hh"
#include "dialog-lyrics.hh"

namespace Bmp
{
  Lyrics::~Lyrics () {}

  Lyrics* Lyrics::create ()
  {
      const std::string path (BMP_GLADE_DIR G_DIR_SEPARATOR_S "dialog-lyrics.glade");
      Glib::RefPtr<Gnome::Glade::Xml> glade_xml = Gnome::Glade::Xml::create (path);
      Lyrics *p = 0;
      glade_xml->get_widget_derived ("trackinfo", p);
      return p;
  }

  Lyrics::Lyrics (BaseObjectType                       * obj,
                  Glib::RefPtr<Gnome::Glade::Xml> const& xml)
      : Gtk::Dialog (obj),
        m_ref_xml   (xml)
  {
      Util::window_set_icon_list (GTK_WIDGET (this->gobj()), "player");

      m_ref_xml->get_widget ("lyrics",        m_widget_lyrics);
      m_ref_xml->get_widget ("entry_artist",  m_widget_entry_artist);
      m_ref_xml->get_widget ("entry_title",   m_widget_entry_title);
  }

  void
  Lyrics::run ( Glib::ustring const& artist,
                Glib::ustring const& title)
  {
      m_widget_entry_artist->set_text  (artist);
      m_widget_entry_title->set_text  (title);

      Glib::ustring text;
      m_widget_lyrics->set_sensitive (false);
      if (Bmp::Lyrictracker::get_lyrics (artist, title, text))
      {
        try {
          m_widget_lyrics->get_buffer ()->set_text (text);
          m_widget_lyrics->set_sensitive (true);
          }
        catch (...) {}
      }
      show_all ();
      Gtk::Dialog::run ();
  }
} // namespace Bmp 
