//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glibmm.h>
#include <glibmm/i18n.h>
#include <gtkmm.h>
#include <libglademm.h>

#include <cstring>
#include <iostream>
#include <sstream>
#include <string>

#include "util_file.hh"
#include "ui_toolbox.hh"
#include "paths.hh"

#include "dialog-filelist.hh"

namespace Bmp
{

  DialogFilelist::~DialogFilelist ()
  {
  }

  DialogFilelist*
  DialogFilelist::create ()
  {
      const std::string path = BMP_GLADE_DIR G_DIR_SEPARATOR_S "dialog-filelist.glade";

      Glib::RefPtr<Gnome::Glade::Xml> glade_xml = Gnome::Glade::Xml::create (path);
      DialogFilelist *dialog = 0;
      glade_xml->get_widget_derived ("dialog-filelist", dialog);
      return dialog;
  }

  DialogFilelist::DialogFilelist (BaseObjectType                        *cobject,
                                  const Glib::RefPtr<Gnome::Glade::Xml> &xml)
      : Gtk::Dialog     (cobject),
        m_ref_xml         (xml),
        view_files      (0)
  {
      Util::window_set_icon_list (GTK_WIDGET (this->gobj()), "player");
      m_ref_xml->get_widget ("view-files", view_files);
  }

  int
  DialogFilelist::run (Util::FileList const& list, Glib::ustring const& message)
  {
      using namespace Util;
  
      dynamic_cast<Gtk::Label *>(m_ref_xml->get_widget ("label-text"))->set_text (message);

      Glib::RefPtr<Gtk::TextBuffer> buffer = Gtk::TextBuffer::create();
      Glib::ustring filenames;

      FileList::const_iterator last = list.end ();
      last--;
      for (FileList::const_iterator iter = list.begin(), end = list.end(); iter != end; ++iter)
        {
            Glib::ustring text;
            try {
                  text = Glib::filename_to_utf8 (*iter);
                }
            catch (Glib::ConvertError& cxe)
                {
                  text = _("(Unable to convert filename to UTF-8 for display. Please set G_FILENAME_ENCODING.)"); 
                }

            filenames.append (text);
            if (iter != last) filenames.append ("\n");
        }

      buffer->set_text (filenames);  
      view_files->set_buffer (buffer);

      return Gtk::Dialog::run ();
  }

} // namespace Bmp
