/***************************************************************************
copyright            : (C) 2005 by Andy Leadbetter
email                : andrew.leadbetter@gmail.com
 ***************************************************************************/

/***************************************************************************
 *   This library is free software; you can redistribute it and/or modify  *
 *   it  under the terms of the GNU Lesser General Public License version  *
 *   2.1 as published by the Free Software Foundation.                     *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  *
 *   USA                                                                   *
 ***************************************************************************/

#include <stdint.h>
#include <stdlib.h>
#include <iostream>

#include <tfile.h>
#include <audioproperties.h>

#include "mp4file.h"
#include "mp4tag.h"


namespace TagLib
{
    MP4::File::File (const char           *file,
                     bool                  read_properties,
                     Properties::ReadStyle properties_style) : TagLib::File (file)
    {
        mp4tag = 0;
        properties = 0;

        mp4file = MP4Modify (file, 1);

        if (isOpen())
            read (read_properties, properties_style);
    }

    MP4::File::~File()
    {
        MP4Close (mp4file);
        delete mp4tag;
        delete properties;
    }

    TagLib::Tag*
    MP4::File::tag() const
    {
        return mp4tag;
    }

    TagLib::MP4::Tag*
    MP4::File::getMP4Tag() const
    {
        return mp4tag;
    }

    void
    MP4::File::SetMetadataFreeForm (std::string const& id,
                                    std::string const& value)
    {
      MP4SetMetadataFreeForm (mp4file,
                              (char*)(id.c_str()), 
                              (uint8_t*)(value.c_str()),
                              strlen(value.c_str())+1);
    }

    bool
    MP4::File::GetMetadataFreeForm (std::string const& id,
                                    std::string & _value_std)
    {
      char * value = 0;
      uint32_t size = 0;
      MP4GetMetadataFreeForm (mp4file,
                              (char*)(id.c_str()), 
                              (uint8_t**)&value, &size);
                       
      if (value)       
        {
          value = (char*)realloc (value, size+1);
          value[size] = '\0';
          _value_std = std::string (value);
          free (value);
          return true;
        }
      else
        {
          return false;
        }
    }


    MP4::Properties*
    MP4::File::audioProperties() const
    {
        return properties;
    }

    bool
    MP4::File::save()
    {
        MP4SetMetadataName    (mp4file, tag()->title().toCString(true)); 
        MP4SetMetadataArtist  (mp4file, tag()->artist().toCString(true)); 
        MP4SetMetadataAlbum   (mp4file, tag()->album().toCString(true)); 
        MP4SetMetadataComment (mp4file, tag()->comment().toCString(true)); 
        MP4SetMetadataGenre   (mp4file, tag()->genre().toCString(true)); 

        char temp[256];
        sprintf (temp, "%04u", tag()->year());

        MP4SetMetadataYear  (mp4file, temp); 
        MP4SetMetadataTrack (mp4file, tag()->track(), 0); 
        MP4SetMetadataCompilation (mp4file, getMP4Tag()->compilation() ? 1 : 0); 

        return true;
    }

    bool
    MP4::File::isOpen()
    {
        return mp4file != MP4_INVALID_FILE_HANDLE;
    }

    void
    MP4::File::read (bool read_properties, Properties::ReadStyle properties_style)
    {
        std::cerr << "Reading properties & metadata\n";

        properties =  new MP4::Properties (properties_style);
        mp4tag = new MP4::Tag ();

        if (mp4file != MP4_INVALID_FILE_HANDLE)
          {
            if(read_properties)
              {
                properties->readMP4Properties( mp4file );
              }
            mp4tag->readTags( mp4file );
          }
    }

}
