
#ifndef HAVE_BMP

#include <mcs/config.h>
#if (1 != MCS_HAVE_GTK)
#  error "This MCS installation was built without GTK+ binding system support!"
#endif

#endif

#ifndef MCS_BIND_H
#define MCS_BIND_H

#include <gtkmm.h>
#include <mcs/base.h>

namespace Mcs
{
  class Bind
  {

    public:

      Bind (Mcs::Mcs * mcs);
      ~Bind ();

      void
      bind_toggle_action  (Glib::RefPtr<Gtk::ToggleAction> toggle_action,
                           std::string const & domain,
                           std::string const & key);

      void
      bind_spin_button  (Gtk::SpinButton * spin_button,
                         std::string const & domain,
                         std::string const & key);

      void
      bind_entry          (Gtk::Entry * entry,
                           std::string const & domain,
                           std::string const & key);
      void
      bind_toggle_button  (Gtk::ToggleButton * button,
                           std::string const & domain,
                           std::string const & key);

      void
      bind_font_button    (Gtk::FontButton * font_button,
                           std::string const & domain,
                           std::string const & key);

      void
      bind_filechooser    (Gtk::FileChooser * filechooser,
                           std::string const & domain,
                           std::string const & key);


      void
      bind_cbox_entry     (Gtk::ComboBoxEntry * cbox_entry,
                           std::string const & domain,
                           std::string const & key);

      void
      bind_cbox           (Gtk::ComboBox * cbox,
                           std::string const & domain,
                           std::string const & key);

      void
      bind_range          (Gtk::Range * range,
                           std::string const & domain,
                           std::string const & key);

    private:
    
      Mcs::Mcs *mcs;

      void
      action_toggled_cb       (Glib::RefPtr<Gtk::ToggleAction> toggle_action,
                               std::string const & domain,
                               std::string const & key);

      void
      spin_button_changed_cb  (Gtk::SpinButton * spin_button,
                               std::string const & domain,
                               std::string const & key);

      void
      entry_changed_cb        (Gtk::Entry * entry,
                               std::string const & domain,
                               std::string const & key);
      void
      button_toggled_cb       (Gtk::ToggleButton * toggle_button,
                               std::string const & domain,
                               std::string const & key);
      void
      font_set_cb             (Gtk::FontButton * font_button,
                               std::string const & domain,
                               std::string const & key);

      void
      fc_current_folder_set
                              (Gtk::FileChooser * filechooser,
                               std::string const & domain,
                               std::string const & key);

      void
      cbox_entry_changed_cb   (Gtk::ComboBoxEntry * cbox_entry,
                               std::string const & domain,
                               std::string const & key);

      void
      cbox_changed_cb         (Gtk::ComboBox * cbox,
                               std::string const & domain,
                               std::string const & key);

      void
      range_value_changed     (Gtk::Range * range,
                               std::string const & domain,
                               std::string const & key);
  
  }; // class Bind
} // namespace Mcs

#endif
