// Neon++ Library, (C) 2006 M. Derezynski
// A C++ wrapper library for neon <http://www.webdav.org/neon>, (C) Joe Orton

#ifndef _NEON_PP_SESSION_
#define _NEON_PP_SESSION_

#include <string>
#include <ne_session.h>
#include <sigc++/sigc++.h>

namespace Neon
{ 
  class Request;
  class Session
  {
    public:

#include "neonpp-exception.hh"

      NEONPPEXCEPTION(SessionCreateError)
      NEONPPEXCEPTION(InvalidTimeoutError)

      typedef sigc::signal<void, ne_conn_status, std::string> StatusNotify;

      Session (std::string const& hostname, std::string const& scheme = std::string("http"), unsigned int port = 80) throw (SessionCreateError);
      ~Session ();      

      void set_proxy (std::string const& hostname, unsigned int port = 8080);
      void set_read_timeout (int timeout) throw (InvalidTimeoutError);
      void close ();
      std::string get_error ();

      StatusNotify&
      status_notify () { return status_notify_; }

    private:

      friend class Neon::Request;

      Session() : session (0) {}

      StatusNotify status_notify_;

      static void _ne_status_notify (void *data, ne_conn_status status, const char * info);
      ne_session *session;
  };
}
#endif
