#!/usr/bin/perl -w -I..

# Tests whether move() works


$| = 1 ;

use Bloksi ;

$s= "AA01\n".
    "AA01\n".
    "23 8\n".
    "4467\n".
    "5567\n".
    "   9";

# Test each piece for the directions left,right,down,up
%test = ("A"=> {"down"=>
		    "  01\n".
		    "AA01\n".
		    "AA 8\n".
		    "2367\n".
		    "4467\n".
		    "55 9" },
	 
	 "0"=> {"down"=>
		    "AA 1\n".
		    "AA01\n".
		    "2308\n".
		    "4467\n".
		    "5567\n".
		    "   9" },
	 "2"=> {"down"=>
		    "AA01\n".
		    "AA01\n".
		    " 3 8\n".
		    "2 67\n".
		    "4467\n".
		    "55 9"  ,
                "right"=>
		    "AA01\n".
		    "AA01\n".
		    " 238\n".
		    "4467\n".
		    "5567\n".
		    "   9" },
	 "3"=> {"down"=>
		    "AA01\n".
		    "AA01\n".
		    "2  8\n".
		    " 367\n".
		    "4467\n".
		    "55 9",
                "right"=>
		    "AA01\n".
		    "AA01\n".
		    "2 38\n".
		    "4467\n".
		    "5567\n".
		    "   9" },
	 "4"=> {"down"=>
		    "AA01\n".
		    "AA01\n".
		    "23 8\n".
		    "  67\n".
		    "4467\n".
		    "55 9" },
	 "5"=> {"down"=>
		    "AA01\n".
		    "AA01\n".
		    "23 8\n".
		    "4467\n".
		    "  67\n".
		    "55 9" },
	 "6"=> {"down"=>
		    "AA01\n".
		    "AA01\n".
		    "23 8\n".
		    "44 7\n".
		    "5567\n".
		    "  69" ,
	        "up"=>
		    "AA01\n".
		    "AA01\n".
		    "2368\n".
		    "4467\n".
		    "55 7\n".
		    "   9" },
	 "8"=> {"left"=>
		    "AA01\n".
		    "AA01\n".
		    "238 \n".
		    "4467\n".
		    "5567\n".
		    "   9" },
	 "9"=> {"left"=>
		    "AA01\n".
		    "AA01\n".
		    "23 8\n".
		    "4467\n".
		    "5567\n".
		    "  9 " },
	 );

$errcnt = 0 ; 
$testcnt = 0 ;

while( ($p,$q) = each( %test ) )
{

    while ( ($dir,$a) = each( %$q  ) )
    {
	$g = new Bloksi $s ;
	$testcnt++ ;
	## print "$g->{s}\n";
	move( $g, $p, $dir ) ;
	## print "$g->{s}\n";
	if( $g->{s} eq $a )
	{
	    print "OK $testcnt\n" ;

	} else {
	    print "Not OK $testcnt\n";
	    print "Move $p in direction $dir should yield :\n" ;
	    print "=" x $g->{w}, "\n", $a,"\n",
	          "-" x $g->{w}, "Rather than\n", $g->{s},"\n",
	          "=" x $g->{w}, "\n";
	    $errcnt++ ;
	}
	## <>;
    }
}

print "In all, there were $errcnt errors in $testcnt trials\n";
print $errcnt ? "back to the drawing board ..." : "Cool!" , "\n" ;


