/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package Movimentacoes;

import Biblioteca.Botoes;
import Biblioteca.Calendario;
import Biblioteca.Datas;
import Biblioteca.Janela;
import Biblioteca.Janelinha;
import Biblioteca.Visual;
import Principal.TelaPrincipal;
import java.sql.SQLException;
import javax.swing.table.DefaultTableModel;

public class TransferenciasPesquisar extends Janela {

    private final String Acao;
    private final Transferencias Transferencias;
    private final TelaPrincipal Principal;

    public TransferenciasPesquisar(TelaPrincipal principal, Transferencias transferencias, String acao) {
        initComponents();
        Visual.Janela(this.getJanela());
        BarraDeFerramentas.add(Botoes.Sair(this));
        Transferencias = transferencias;
        Acao = acao;
        Principal = principal;
        resultado_pesquisa.setFont(FonteFinancas);
        resultado_pesquisa.getTableHeader().setFont(FonteFinancas);
    }
    
    public void Filtrar()
    {
        if(data.getSelectedItem()==null)
        {
            Banco.executeQuery("SELECT transferencias.*, TO_CHAR(transferencias.data,'DD/MM/YYYY') AS data_exibir, transferencias_itens.nome AS item_nome, transferencias_categorias.nome AS categoria_nome FROM transferencias, transferencias_itens, transferencias_categorias WHERE transferencias_itens.nome LIKE '%"+item.getText()+"%' AND transferencias.id_item=transferencias_itens.id_item AND transferencias_itens.id_categoria=transferencias_categorias.id_categoria ORDER BY transferencias.data DESC, transferencias.hora DESC");
        }else{
            Banco.executeQuery("SELECT transferencias.*, TO_CHAR(transferencias.data,'DD/MM/YYYY') AS data_exibir, transferencias_itens.nome AS item_nome, transferencias_categorias.nome AS categoria_nome FROM transferencias, transferencias_itens, transferencias_categorias WHERE transferencias_itens.nome LIKE '%"+item.getText()+"%' AND transferencias.data LIKE '%"+Datas.ConverterData(data.getSelectedItem().toString())+"%' AND transferencias.id_item=transferencias_itens.id_item AND transferencias_itens.id_categoria=transferencias_categorias.id_categoria ORDER BY transferencias.data DESC, transferencias.hora DESC");
        }

        try
        {
            DefaultTableModel modelo = (DefaultTableModel)resultado_pesquisa.getModel();
            modelo.setNumRows(0);
            while(Banco.getResultSet().next())
            {
                modelo.addRow(new Object[]{Banco.getResultSet().getString("id_transferencia"),Banco.getResultSet().getString("item_nome"),Banco.getResultSet().getString("categoria_nome"),Lingua.getMensagem("moeda")+" "+Banco.getResultSet().getString("valor"),Banco.getResultSet().getString("data_exibir")+" "+Banco.getResultSet().getString("hora")});
            }
        }catch(SQLException e)
        {
            Janelinha.Aviso(Lingua.getMensagem("atencao"),Lingua.getMensagem("excecao")+" "+e.getMessage());
        }
    }
    
    @Override
    public void Botoes(String acao)
    {
        if(acao.equals(Lingua.getMensagem("sair"))){
            TransferenciasPesquisar.this.dispose();
        }
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        BarraDeFerramentas = new javax.swing.JToolBar();
        pesquisar_venda = new javax.swing.JPanel();
        scroll_pesquisa = new javax.swing.JScrollPane();
        resultado_pesquisa = new javax.swing.JTable();
        CLIENTE_NOME = new javax.swing.JLabel();
        item = new javax.swing.JTextField();
        ESTADO = new javax.swing.JLabel();
        BFiltrar = new javax.swing.JButton();
        data = new Calendario(false);

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable1);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Lingua.getMensagem("pesquisar"));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        getContentPane().setLayout(null);

        BarraDeFerramentas.setFloatable(false);
        BarraDeFerramentas.setRollover(true);
        getContentPane().add(BarraDeFerramentas);
        BarraDeFerramentas.setBounds(0, 0, 710, 41);

        pesquisar_venda.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Lingua.getMensagem("transferencia"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, FonteFinancas, new java.awt.Color(0, 102, 204)));
        pesquisar_venda.setForeground(new java.awt.Color(51, 94, 168));

        resultado_pesquisa.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "ID", "", "", "", ""
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        resultado_pesquisa.getTableHeader().setReorderingAllowed(false);
        resultado_pesquisa.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                resultado_pesquisaMouseClicked(evt);
            }
        });
        scroll_pesquisa.setViewportView(resultado_pesquisa);
        if (resultado_pesquisa.getColumnModel().getColumnCount() > 0) {
            resultado_pesquisa.getColumnModel().getColumn(0).setMaxWidth(40);
            resultado_pesquisa.getColumnModel().getColumn(1).setHeaderValue(Lingua.getMensagem("nome"));
            resultado_pesquisa.getColumnModel().getColumn(2).setHeaderValue(Lingua.getMensagem("categoria"));
            resultado_pesquisa.getColumnModel().getColumn(3).setHeaderValue(Lingua.getMensagem("valor"));
            resultado_pesquisa.getColumnModel().getColumn(4).setHeaderValue(Lingua.getMensagem("data"));
        }

        CLIENTE_NOME.setFont(FonteFinancas);
        CLIENTE_NOME.setText(Lingua.getMensagem("item")+":");

        item.setFont(FonteFinancas);
        item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itemActionPerformed(evt);
            }
        });

        ESTADO.setFont(FonteFinancas);
        ESTADO.setText(Lingua.getMensagem("data")+":");

        BFiltrar.setFont(FonteFinancas);
        BFiltrar.setText(Lingua.getMensagem("pesquisar"));
        BFiltrar.setPreferredSize(null);
        BFiltrar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BFiltrarActionPerformed(evt);
            }
        });

        data.setFont(FonteFinancas);

        javax.swing.GroupLayout pesquisar_vendaLayout = new javax.swing.GroupLayout(pesquisar_venda);
        pesquisar_venda.setLayout(pesquisar_vendaLayout);
        pesquisar_vendaLayout.setHorizontalGroup(
            pesquisar_vendaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pesquisar_vendaLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pesquisar_vendaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(scroll_pesquisa)
                    .addGroup(pesquisar_vendaLayout.createSequentialGroup()
                        .addComponent(CLIENTE_NOME)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(item)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ESTADO)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(data, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(BFiltrar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        pesquisar_vendaLayout.setVerticalGroup(
            pesquisar_vendaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pesquisar_vendaLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pesquisar_vendaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(CLIENTE_NOME)
                    .addComponent(BFiltrar, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(item, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ESTADO)
                    .addComponent(data, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(scroll_pesquisa, javax.swing.GroupLayout.DEFAULT_SIZE, 302, Short.MAX_VALUE)
                .addContainerGap())
        );

        getContentPane().add(pesquisar_venda);
        pesquisar_venda.setBounds(10, 60, 560, 389);

        setSize(new java.awt.Dimension(590, 489));
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

private void itemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itemActionPerformed
    Filtrar();
}//GEN-LAST:event_itemActionPerformed

private void BFiltrarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BFiltrarActionPerformed
    Filtrar();
}//GEN-LAST:event_BFiltrarActionPerformed

private void resultado_pesquisaMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_resultado_pesquisaMouseClicked
    String codSelecionado0;
    String codSelecionado1;
    String codSelecionado3;
    codSelecionado0 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 0);
    codSelecionado1 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 1);
    codSelecionado3 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 3);
    if(Janelinha.Pergunta(codSelecionado1, Lingua.getMensagem("tem_certeza"))){
        Transferencias.PreencherFormulario(Acao, codSelecionado0);
        TransferenciasPesquisar.this.dispose();
    }
}//GEN-LAST:event_resultado_pesquisaMouseClicked


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton BFiltrar;
    private javax.swing.JToolBar BarraDeFerramentas;
    private javax.swing.JLabel CLIENTE_NOME;
    private javax.swing.JLabel ESTADO;
    private javax.swing.JComboBox data;
    private javax.swing.JTextField item;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JPanel pesquisar_venda;
    private javax.swing.JTable resultado_pesquisa;
    private javax.swing.JScrollPane scroll_pesquisa;
    // End of variables declaration//GEN-END:variables

}
