<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    search-index-defs.php                                   */
/* Author:      Paul Waite                                              */
/* Description: Definitions for interfacing to a search engine to       */
/*              perform indexing operations.                            */
/*              The parent module which includes this module must also  */
/*              include the underlying defs module for the search       */
/*              engine itself, eg: lucene, solr etc.                    */
/*                                                                      */
/* ******************************************************************** */
/** @package search */

/** Generic search classes */
include_once("search-defs.php");

// ----------------------------------------------------------------------
/**
* The indexer class. This class inherits all the functionality
* of the searchengine_connection, searchengine_msg and searchengine_message
* classes. It adds indexing-specific methods.
* @package search
*/
class searchengine_indexer extends searchengine_indexmsg {
  // .....................................................................
  /** Constructor
  * Make a new SearchEngine indexer.
  * @param string $application Optional application specifier
  * @param string $host Hostname or IP of SearchEngine server
  * @param string $port Port of SearchEngine server
  * @param string $serialno Optional specific serial number to use
  */
  function searchengine_indexer($application="?", $host="", $port="", $serialno="") {
    $this->searchengine_indexmsg($application, $host, $port, $serialno);
  } // searchengine_indexer

  // .....................................................................
  /**
   * Make SearchEngine execute the indexing funtion for the document.
  * @param integer $timeoutsecs Override for timeout in seconds
  * @return boolean True if indexing was successful.
   */ 
  function execute($timeoutsecs="") {
    return $this->send($timeoutsecs);
  } // execute
} // searchengine_indexer class

// ----------------------------------------------------------------------
/**
* The SearchEngine unindexer class. This class allows you to remove an
* item from the SearchEngine index. You must know the unique ID that identifies
* the document.
* @package search
*/
class searchengine_unindexer extends searchengine_unindexmsg {
  // .....................................................................
  /** Constructor
  * Make a new SearchEngine unindexer. This is provided to allow you to
  * delete an item from the SearchEngine index. It has a single method
  * 'unindex' which takes the ID of the item to delete.
  * @param string $application Optional application specifier
  * @param string $host Hostname or IP of SearchEngine server
  * @param string $port Port of SearchEngine server
  */
  function searchengine_unindexer($application="?", $host="", $port="") {
    $this->searchengine_unindexmsg($application, $host, $port);
  } // searchengine_unindexer
  // .....................................................................
  /**
  * Unindex the given document, as identified by the unique ID. If no errors
  * arise, then the item will be removed from the SearchEngine index.
  * @param string $id The ID to allow SearchEngine to identify the item to unindex
  */
  function execute($timeoutsecs="") {
    return $this->send($timeoutsecs);
  } // execute
} // searchengine_unindexer class

// ----------------------------------------------------------------------
?>