/* ----------------------------------------------------------------------------------
   dtostrf.S

   Contributors:
     Created by Reiner Patommel

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.


 -*- Mode: Asm -*-

*-----------------------------------------------------------------------------------
* A = *dtostrf(double num, char width, char precision, char *str)
* Converts a double (float) to a string in the printf f format.
* This is a substitute for printf("%width.precisionf", num,)
* Width is the minimum width of the output string including '.' and possible sign.
* Precision is the number of digits required after the decimal point.
* If precision is < 0, the string is left adjusted with leading spaces.
* If precision is > 0, the string is right adjusted with trailing spaces.
* The number will be rounded based on precision.
*----------------------------------------------------------------------------------*/

#include "gasava.inc"
#include "fplib.inc"
#include "macros.inc"

#define p_num_hi_hi		r25
#define p_num_hi_lo		r24
#define p_num_lo_hi		r23
#define p_num_lo_lo		r22
#define p_width			r20
#define p_prec			r18
#define p_str_hi		r17
#define p_str_lo		r16			/* parameters	*/

#define ret_hi			r25
#define ret_lo			r24			/* return value	*/

#define r_count   		r17			/* exponent and loop counter */
#define r_dp      		r16			/* position of decimal point */

    TEXT_SEG(fplib, dtostrf)
    FUNCTION(dtostrf)

GLOBAL(dtostrf)
	push	YH
	push	YL						; save frame pointer
	push	p_str_hi
	push	p_str_lo				; save &string
	mov		YH,	p_str_hi
	mov		YL, p_str_lo			; Y points to string
	mov		r17, p_num_hi_hi
	mov		r16, p_num_hi_lo
	add		r16, r16
	adc		r17, r17
	cpi		r17, 0xff				; NAN ?
	brne	_sign
	ldi		rA3, 'N'
	ldi		rA2, 'A'
	st		Y+, rA3					; 'N'
	st		Y+, rA2					; 'A'
	st		Y+, rA3					; 'N'
	rjmp	_dtostrf_exit
_sign:								; if (num < 0) {num = -num; *string = '-';}
	push	p_width					; save width
	tst		p_num_hi_hi				; num < 0?
	brpl	_rounding
	ldi		r16, '-'				; num is negative
	st		Y+, r16					;  write '-' sign
	andi	rA3, 0x7F				;  make num positive
_rounding:							; num += (0.5 * 10^-p_precision);
	mov		r_dp, p_prec			; decimal point is at precision + 1
	inc		r_dp					;  when counting down to 0
	push	p_num_hi_hi
	push	p_num_hi_lo
	push	p_num_lo_hi
	push	p_num_lo_lo				; save num
	mov		rA0, p_prec
	clr		rA1
	clr		rA2
	clr		rA3						; A = precision
	XCALL   _U(__floatsisf)        	; now A = (float)precision
	ori		rA3, 0x80				; now A = (float) -precision
	mov		rB3, rA3
	mov		rB2, rA2
	mov		rB1, rA1
	mov		rB0, rA0				; now B = (float) -precision
	ldi		rA3, 0x41
	ldi		rA2, 0x20
	clr		rA1
	clr		rA0						; A = 10.0
	XCALL	_U(pow)					; now A = 10^ -precision
	ldi		rB3, 0xff
	ldi		rB2, 0xff				; rB3:rB2 = -1
	XCALL	_U(ldexp)				; now A = (0.5 * 10^-precision)
	pop		rB0
	pop		rB1
	pop		rB2
	pop		rB3						; B = num
	XCALL	_U(__addsf3)			; now A = num + (0.5 * 10^-precision)
	mov		r_count, r_dp			; count becomes power10 + dp.
	cpi		r_dp, 1					; force dp to 0 if dp = 1 i.e. precision = 0
	brne	_normalize_loop
	clr		r_dp
_normalize_loop:					; while (num >= 10.0) {num /= 10; count++;}
	ldi		rB3, 0x41
	ldi		rB2, 0x20
	clr		rB1
	clr		rB0						; B = 10.0
	cp		rA0, rB0
	cpc		rA1, rB1
	cpc		rA2, rB2
	cpc		rA3, rB3				; num >= 10.0?
	brlt	_conversion_loop
	XCALL	_U(__divsf3)			; num /= 10.0
	inc		r_count					; count++
	rjmp	_normalize_loop
_conversion_loop:					; for (i = count; i > 0; count--;)
	push	rA3						;  {n = num; n += '0'; *string++ = n; num -= n;
	push	rA2						;   num *= 10; if (i == dp) *string = '.';}
	push	rA1
	push	rA0
	XCALL   _U(__fixsfsi)        	; convert num to long ( =n)
	mov		r21, rA0 				; n = num
	subi	r21, -'0'				; n += '0'
	st		Y+, r21					; *string++ = n
	XCALL	_U(__floatsisf)			; convert n to float
	pop		rB0
	pop		rB1
	pop		rB2
	pop		rB3						; B = num
	XCALL	_U(__subsf3)			; A = (A - B)
	subi	rA3, 0x80				; A = -(A - B) = B - A  -> num -= n
	ldi		rB3, 0x41
	ldi		rB2, 0x20
	clr		rB1
	clr		rB0						; B = 10.0
	XCALL	_U(__mulsf3)			; num *= 10
	cp		r_count, r_dp			; decimal point here?
	brne	_next
	ldi		r21 , '.'
	st		Y+, r21					; write decimal point
_next:
	dec		r_count
	brne	_conversion_loop
_adjust:
	st		Y, __zero_reg__			; terminate string
	pop		r21						; get width again
	pop		ZL						; Y points to end of string
	pop		ZH						; Z points to start of string
	push	ZH
	push	ZL						; save &string again
	mov		p_width, r21
	tst		p_width					; width < 0?
	brpl	_adjust_1
	com		p_width					; make width positive
	inc		p_width
_adjust_1:							; strlen = Y - Z
	mov		rA3, YH
	mov		rA2, YL
	mov		rA1, ZH
	mov		rA0, ZL
	sub		rA2, rA0
	sbc		rA3, rA1				; rA2 = strlen
	mov		r_count, p_width
	sub		r_count, rA2			; r_count = # of leading/trailing spaces
	ldi		rA3, ' '
	cp		rA2, p_width			; if (strlen >= abs(width)) exit
	brge	_exit
	tst		r21						; width < 0?
	brmi	_l_adjust
_r_adjust:							; right adjust with leading spaces
	adiw	YL, 1					; now Y points to end+1 of string
	adiw	ZL, 1
	add		ZL, p_width
	adc		ZH, __zero_reg__		; now Z points to end+1 of final string
	inc		rA2						; rA2 = strlen+1
_r_adjust_loop:						; right shift string
	ld		r21, -Y
	st		-Z, r21
	dec		rA2
	brne	_r_adjust_loop
_r_adjust_spaces:					; make leading spaces
	st		-Z, rA3
	dec		r_count
	brne	_r_adjust_spaces
	rjmp	_exit
_l_adjust:							; make trailing spaces
	st		Y+, rA3
	dec		r_count
	brne	_l_adjust
_dtostrf_exit:
	st		Y, __zero_reg__			; terminate string
_exit:
	pop		ret_lo
	pop		ret_hi					; restore &string as return address
	pop		YL
	pop		YH						; restore frame pointer
	ret

	ENDFUNC
;-----------------------------------------------------------------------------------