/****************************************************************
**
** Attal : Lords of Doom
**
** template.cpp
** this is a template for all .cpp files
**
** Version : $Id: fightSettingsDialog.cpp,v 1.1 2003/12/09 20:06:37 tribunal2 Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/01/2002
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


// generic include files

// include files for QT
#include <qcheckbox.h>
#include <qlayout.h>
#include <qpushbutton.h>
// application specific include files
#include "fightSettingsDialog.h"
#include "libCommon/attalSettings.h"
#include "libClient/gui.h"

#include "libClient/askWidget.h"

/** add comments here */
FightSettingsDialog::FightSettingsDialog( QWidget* parent )
	:QDialog ( parent )
{
	AnimationCheckBox = new QCheckBox ( tr ( "Animation" ), this );
	connect ( AnimationCheckBox, SIGNAL ( clicked () ), this, SLOT ( slot_animationCheckBoxClicked () ) );

	AnimationSpeed = new AskInt ( tr( "Animation Speed" ), this );
	AnimationSpeed->setMinValue ( 1 );
	AnimationSpeed->setMaxValue ( 10 );

	CellsCheckBox = new QCheckBox ( tr ( "Show cells" ), this );

	QPushButton * okButton = new QPushButton( this );
	okButton->setText( tr( "Ok" ) );
	connect ( okButton, SIGNAL ( pressed ( ) ), this, SLOT ( slot_okButtonClicked ()) );

	QVBoxLayout* layout = new QVBoxLayout ( this );
	layout->setMargin ( 15 );
	layout->addWidget ( AnimationCheckBox, 1 , Qt::AlignHCenter );
	layout->addWidget ( AnimationSpeed, 1, Qt::AlignHCenter );
	layout->addWidget ( CellsCheckBox, 1, Qt::AlignHCenter );
	layout->setSpacing ( 10 );
	layout->addWidget( okButton, 1 , Qt::AlignHCenter );

	layout->activate();

	FightSettings fsettings = AttalSettings::getFightSettings ();

	AnimationSpeed->setEnabled ( fsettings.IsAnimationEnabled );
	AnimationSpeed->setValue ( fsettings.AnimationSpeed );

	AnimationCheckBox->setChecked ( fsettings.IsAnimationEnabled );
	CellsCheckBox->setChecked ( fsettings.AreCellsVisible );

	FIXEDSIZE (this);
}

void FightSettingsDialog::slot_okButtonClicked()
{
	accept ();
}

void FightSettingsDialog::slot_cancelButtonClicked()
{
	QDialog::reject ();
}

void FightSettingsDialog::accept ()
{
	FightSettings fsettings;
	fsettings.IsAnimationEnabled = AnimationCheckBox->isChecked ();
	fsettings.AnimationSpeed = AnimationSpeed->getValue ();
	fsettings.AreCellsVisible = CellsCheckBox->isChecked ();
	AttalSettings::setFightSettings ( fsettings );

	QDialog::accept ();
}

void FightSettingsDialog::slot_animationCheckBoxClicked()
{
	AnimationSpeed->setEnabled ( AnimationCheckBox->isChecked () );
}

