#ifndef ATL_dGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,160,320,720,880,1120,1280,1360,1520
 * N : 25,160,320,720,880,1120,1280,1360,1520
 * NB : 2,12,16,16,16,24,32,80,80
 */
#define ATL_dGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 92) (nb_) = 2; \
   else if ((n_) < 240) (nb_) = 12; \
   else if ((n_) < 1000) (nb_) = 16; \
   else if ((n_) < 1200) (nb_) = 24; \
   else if ((n_) < 1320) (nb_) = 32; \
   else (nb_) = 80; \
}


#endif    /* end ifndef ATL_dGetNB_geqrf */
