#ifndef	ENVIRONMENT_DEFINE
#define	ENVIRONMENT_DEFINE

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "main.h"

enum landscapeTypes {
	LANDTYPE_RANDOM,
	LANDTYPE_CANYONS,
	LANDTYPE_MOUNTAINS,
	LANDTYPE_VALLEYS,
	LANDTYPE_HILLS,
	LANDTYPE_FOOTHILLS,
	LANDTYPE_PLAIN,
};

enum landSlideTypes {
	LANDSLIDE_NONE,
	LANDSLIDE_INSTANT,
	LANDSLIDE_GRAVITY,
};

class TANK;
class MISSILE;
class FLOATTEXT;
class GLOBALDATA;
class VIRTUAL_OBJECT;
class ENVIRONMENT {
	protected:
	GLOBALDATA	*_global;

	public:
	TANK	*order[MAXPLAYERS * 3];
	VIRTUAL_OBJECT	*objects[MAX_OBJECTS];
	int	availableItems[THINGS];
	int	numAvailable;
	int	realm, am;
	double	wind, lastwind;
	double	windstrength, windvariation;
	double	viscosity;
	double	gravity;
	double	techLevel;
	double	meteors;
	double	lightning;
	double	fog;
	int	oldFogX, oldFogY;
	double	landType;
	double	landSlideType;
	char	*done;
	int	*fp;
	int	*h;
	int	*surface;
	int	*dropTo;
	double	*velocity;
	double	*dropIncr;
	double	*height;
	BITMAP	*db, *terrain, *sky;
	int	pclock, mouseclock;
	int	stage;
	int	combineUpdates;

	ENVIRONMENT () {};
	ENVIRONMENT (GLOBALDATA *global);
	void initialise ();
	void setGlobaldata (GLOBALDATA *global) {_global = global;};
	void generateAvailableItemsList ();
	char isItemAvailable (int itemNum);
	int addObject (VIRTUAL_OBJECT *object);
	int removeObject (VIRTUAL_OBJECT *object);
	VIRTUAL_OBJECT *getNextOfClass (int classNum, int *index);
	void newRound ();
	int ingamemenu ();
	void do_updates ();
	void replaceCanvas ();
	void make_update (int x, int y, int w, int h);
	void make_bgupdate (int x, int y, int w, int h);

	int saveToFile (FILE *file);
	int loadFromFile (FILE *file);
};

#endif
