
#include "filter.hh"
#include "repl.hh"

namespace afilter {

  bool operator < (const FilterItrPart & rhs, const FilterItrPart & lhs) 
  {
    if (rhs.order_num() != lhs.order_num()) 
      return rhs.order_num() < lhs.order_num();
    else
      return rhs.name() < lhs.name();
  }

  void reset(FilterItrPart * i) 
  {
    if (i->real()) reset(i->real()); 
    i->reset();
  }

  void restart(FilterItrPart * itr, const FilterItrRoot & start) {
    itr->root()->restart(start);
  }

  void scan(FilterItrPart * itr, const FilterItrRoot & stop) 
  {
    FilterItrRoot * root_ = itr->root();
    for (FilterItrPart * i = itr; i != 0 && *root_ != stop; i = i->real())
      i->scan(stop, root_);
    // Note: the the process of scanning will increment root if any
    // scanning is done
    if (*root_ != stop)
      root_->assign(&stop);
  }

  FilterItrPart * add(FilterItrPart * itr, FilterItrPart * to_add) 
  {
    if (!itr) {
      return to_add;
    } else {
      reset(itr);
      // this is transversing backwards in the list
      // the links are going this way
      // root <--- filter <---- filter
      FilterItrPart * i    = itr;
      FilterItrPart * prev = 0;  // or next depending on how you think about it
      while (i && *i > *to_add) 
	{prev = i; i = i->real();}

      if (prev) prev->itr.release(); 
      to_add->itr.reset(i);
      if (prev) prev->itr.reset(to_add);
      if (prev) return itr;
      else      return to_add;
    }
  }

  FilterItrPart * find(FilterItrPart * i, const string & name) {
    while (i && i->name() != name) 
      i = i->real();
    return i;
  }

  const FilterItrPart * find(const FilterItrPart * i, const string & name) {
    while (i && i->name() != name) 
      i = i->real();
    return i;
  }

  FilterItrPart * get_url_skip_itr(ConfigData &);
  FilterItrPart * get_sgml_skip_itr(ConfigData &);
  FilterItrPart * get_email_skip_itr(ConfigData &);
  FilterItrPart * get_tex_skip_itr(ConfigData &);

  FilterItrPart * get_filter_itr (const string & name, ConfigData & opts) {
    string::size_type pos = name.find('/');
    if (pos != string::npos)
      return get_repl_itr(name.substr(0,pos), name.substr(pos+1), opts);
    struct pair {
      const char * name;
      FilterItrPart * (*fun) (ConfigData &);
    };
    pair data[] = {
      {"url",   get_url_skip_itr},
      {"sgml",  get_sgml_skip_itr},
      {"email", get_email_skip_itr},
      {"tex",   get_tex_skip_itr}
    };
    for (int i = 0; i != sizeof(data)/sizeof(pair); ++i) {
      if (data[i].name == name) 
	return (*data[i].fun)(opts);
    }
    return 0;
  }
}
