// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __OptsParser_h__
#define __OptsParser_h__

#include "SimpleParser.h"
#include <vector>
#include <string>
using namespace std;

namespace Puma {


class OptsParser : public SimpleParser {
  vector<string> m_argv;
  unsigned int m_curarg;
  unsigned int m_tonext;
  int m_number;

  string m_arg;
  string m_opt;
   
public:
  
  enum {NOARG =-4, ERR = -3, NOOPTION = -2, UNKNOWN = -1, FINISH = 0 };
  
  enum ArgType { AT_NONE = 0, AT_MANDATORY = 1, AT_OPTIONAL = 2 };
  
  struct Option {
    int number;
    char key; 
    const char *name;
    const char *desc;
    ArgType args;
  };

private:
  const Option *m_opts;
   
public:
  OptsParser (int, char **, const Option *);
  OptsParser (const string &, const Option *);

  int getCurrentArgNum () const;
  int getNextArgNum () const;
  int getOption ();
  int getResult () const;
  
  const string &getArgument () const;
  const string &getOptionName () const;

  bool revokeArgument();
   
private:
  int  getShortOption (const string &);
  int  getLongOption  (const string &);
  bool processOption  (const string &, unsigned int,ArgType argtype);
};


} // namespace Puma

#endif /* __OptsParser_h__ */
