/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import jd.io.FileUtil;
import org.xml.sax.InputSource;

public class XmlSource {
    private String uri_;
    private File file_;
    private URL url_;
    private InputStream inputStream_;
    private Reader reader_;
    private String readerEncoding_;
    private boolean closeInput_;
    private Object parser_;
    private Object document_;
    private InputSource inputSource_;

    public XmlSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.uri_ = string;
    }

    public XmlSource(String string, Object object) {
        this(string);
        if (object == null) {
            throw new IllegalArgumentException("document is null");
        }
        this.document_ = object;
    }

    public XmlSource(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.file_ = file;
        this.uri_ = "file:" + file.getCanonicalPath();
        if (File.separatorChar == '\\') {
            this.uri_ = this.uri_.replace('\\', '/');
        }
    }

    public XmlSource(URL uRL) {
        this(uRL.toExternalForm());
        this.url_ = uRL;
    }

    public XmlSource(String string, InputStream inputStream, boolean bl) {
        this(string);
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream is null (uri='" + string + "')");
        }
        this.inputStream_ = inputStream;
        this.closeInput_ = bl;
    }

    public XmlSource(String string, Reader reader, boolean bl, String string2) {
        this(string);
        if (reader == null) {
            throw new IllegalArgumentException("reader is null (uri='" + string + "')");
        }
        this.reader_ = reader;
        this.readerEncoding_ = string2;
        this.closeInput_ = bl;
    }

    public XmlSource(InputSource inputSource) {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource is null");
        }
        if (inputSource.getSystemId() == null) {
            throw new IllegalArgumentException("InputSource has no systemId");
        }
        this.uri_ = inputSource.getSystemId();
        this.reader_ = inputSource.getCharacterStream();
        this.readerEncoding_ = inputSource.getEncoding();
        this.inputStream_ = inputSource.getByteStream();
        this.inputSource_ = inputSource;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
    }

    public void setParser(Object object) {
        this.parser_ = object;
    }

    public Object getParser() {
        return this.parser_;
    }

    public String getUri() {
        return this.uri_;
    }

    public InputSource getInputSource() throws IOException {
        if (this.document_ != null) {
            return null;
        }
        if (this.inputSource_ == null) {
            this.inputSource_ = new InputSource(this.uri_);
            if (this.reader_ != null) {
                this.inputSource_.setCharacterStream(this.reader_);
                this.inputSource_.setEncoding(this.readerEncoding_);
            } else if (this.inputStream_ != null) {
                this.inputSource_.setByteStream(this.inputStream_);
            } else {
                try {
                    this.openInputStream();
                    this.inputSource_.setByteStream(this.inputStream_);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.inputSource_;
    }

    public Object getDocument() {
        return this.document_;
    }

    public String getDocumentContent() throws IOException {
        if (this.document_ != null) {
            if (!(this.document_ instanceof String)) {
                throw new IllegalStateException("document is not a string: " + this.document_);
            }
        } else if (this.reader_ != null) {
            this.document_ = FileUtil.read(this.reader_);
            this.cleanup();
        } else {
            if (this.inputStream_ == null) {
                this.openInputStream();
            }
            this.document_ = FileUtil.read(this.inputStream_);
            this.cleanup();
        }
        return (String)this.document_;
    }

    private void openInputStream() throws IOException {
        this.closeInput_ = true;
        this.inputStream_ = this.file_ != null ? new BufferedInputStream(new FileInputStream(this.file_)) : (this.url_ != null ? this.url_.openStream() : XmlSource.openInputStream(this.uri_));
    }

    public static InputStream openInputStream(String string) throws IOException {
        File file = new File(string.startsWith("file:") ? string.substring(5) : string);
        if (file.exists()) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        URL uRL = new URL(string);
        return uRL.openStream();
    }

    public void cleanup() {
        if (this.closeInput_) {
            FileUtil.close(this.inputStream_);
            FileUtil.close(this.reader_);
        }
        this.inputSource_ = null;
        this.inputStream_ = null;
        this.reader_ = null;
    }

    public void reset() throws IOException {
        this.cleanup();
        this.openInputStream();
    }
}

