------------------------------------------------------------------------------
--                                                                          --
--                  COMMON ASIS TOOLS COMPONENTS LIBRARY                    --
--                                                                          --
--                  A S I S _ U L . E N V I R O N M E N T                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2004-2005, AdaCore                      --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not, write to the Free Software Foundation, 59 Temple Place  --
--  - Suite 330, Boston,                                                    --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains routines for creating, maintaining and cleaning up
--  the working environment for an ASIS tool

package ASIS_UL.Environment is

   procedure Initialize;
   --  This procedure is supposed to perform the common initialization
   --  actions, such as scanning the tool parameters, checking that the
   --  parameter values are compatible, creating the temporary directory and
   --  moving into it. Parameter scanning and checking are tool-specific,
   --  so the corresponding bodies should be provided (see the body for the
   --  details).
   --
   --  When this procedure is completed, ASIS_UL.Common.Arg_List should contain
   --  the full list of options needed to call the compiler to create the tree,
   --  and all the source files that will have to be processed by the tool.
   --  That is, if the tool is based on ASIS_UL.One_Arg_Driver driver, then
   --  ASIS_UL.Common.Arg_File should be a full normalized name of some
   --  existing file (given in absolute form). If the tool is based on ???
   --  driver (source file table), the source file table should contain
   --  full normalized names of some existing files (also given in absolute
   --  form). And in any case ASIS_UL.Common.Arg_List should contain the full
   --  list of options needed to call the compiler to create the tree.
   --
   --  This procedure should raise Parameter_Error in case if anything is wrong
   --  with tool parameters or/and options. In particular, Parameter_Error
   --  should be raised if no existing source file is set.

   procedure Go_To_Temp_Dir (With_Dir_For_Comp_Output : Boolean := False);
   --  Creates the temporary directory for all the compilations performed
   --  by the tool and changes the tool working directory to this temporary
   --  directory. Raises Fatal_Error if creating of the temporary directory
   --  failed because of any reason. If With_Dir_For_Comp_Output is set ON,
   --  creates in this temporary directory another temporary directory to place
   --  the compiler diagnostic output in.
   --  Sets ASIS_UL.Environment and ASIS_UL.Common.Compiler_Output_File_Name

   procedure Context_Clean_Up;
   --  Closes and dissociates the context, if needed

   procedure Clean_Up;
   --  Performs the general final clean-up actions, including closing and
   --  deleting of all files in the temporary directory and deleting this
   --  temporary directory itself.

   procedure Prepare_Context (Success : out Boolean);
   --  This procedure performs all the steps needed to prepare the ASIS Context
   --  (represented by ASIS_UL.Common.The_Context and to make it ready for all
   --  the ASIS-based processing. It assumes that ASIS_UL.Common.Arg_File
   --  points to the full normalized name of some existing source, and
   --  ASIS_UL.Common.Arg_List contains all the options needed to compile this
   --  source. This procedure compiles this source to get the tree file, if the
   --  tree is successfully created, it opens the 'C1' Context based on this
   --  tree, and sets ASIS_UL.Common.The_CU to point to the main
   --  unit in this tree. ASIS_UL.Common.Tree_File is set to the short name of
   --  the tree file that has been created. If all these actions are
   --  successfully performed, Success is set ON, otherwise it is set OFF.

end ASIS_UL.Environment;
