#ifndef protocolesoundh
#define protocolesoundh

#include <glib.h>
#include <protocol-esound-spec.h>

typedef struct
{
  int fd;
  guint32 id;
  gboolean swap;
} ProtocolEsoundClient;

typedef gint(*ProtocolEsoundHandlerProc) (ProtocolEsoundClient *client, ProtocolEsoundCommand command);

typedef struct
{
  ProtocolEsoundCommand command;
  ProtocolEsoundHandlerProc proc;
  gchar* description;
} ProtocolEsoundHandler;

void protocol_esound_new_socket(int fd);

extern gboolean protocol_esound_auth_locked;


#endif
