#ifndef gch
#define gch

#include <glib.h>

// Functions to be called on object cleanup have to be of the following protoype:
typedef void (*GcFreeProc)(gpointer data);

// Add an object to the gc (with a name for debugging purposes)
gpointer gc_add(gpointer data, GcFreeProc proc, gchar *name);

// Increase the reference counter by one
gpointer gc_ref_inc(gpointer data);

// Decrease the reference counter by one
void gc_ref_dec(gpointer data);

// Chech whether all objects have been freed
void gc_cleanup();

// Return refernce counter (not always reliable)
guint gc_ref_count(gpointer data);

// Check if the calling thread is the only one having a reference to the object
gboolean gc_ref_single(gpointer data);

#endif
