/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __ISOPAGE_H__
#define __ISOPAGE_H__

#include "_isopage.h"

#include "configdlg.h"
//#include "isofs.h"

/*========================================================*/

class ArsonIsoPresets;
class QXmlAttributes;
class ArsonIsoFlags;
class QListViewItem;
class QListView;

struct iso_option
{
	iso_option (const QXmlAttributes &attr);

	void setListViewItem (QListViewItem *ptr) { pItem = ptr; }

	QListViewItem *listViewItem (QListView *plv);

	virtual void takeAction (void) { }

	virtual void apply (const ArsonIsoFlags *pFlags) { }
	virtual void save (ArsonIsoFlags *pFlags) { }

protected:
	virtual QListViewItem *createItem (QListView *plv) = 0;

	QListViewItem *pItem;
	QString opt;
	QString desc;
};

/*========================================================*/

class isoOptionParser;

class ArsonIsoPage : public ArsonIsoPageBase, public ArsonConfigPage
{
	Q_OBJECT

	typedef QValueList<iso_option*> OPTIONLIST;
	
public:
	ArsonIsoPage (ArsonConfig &cfg, ArsonConfigDlg *pdlg, QWidget *parent);
	virtual ~ArsonIsoPage (void);

	QString presetName (void) const;
	
private:
	virtual void on_dblclk (QListViewItem *pItem);
	virtual void on_preset_change (int index);
	virtual void set_default_clicked (void);
	virtual void update_preset (void);
	virtual void add_preset (void);
	virtual void del_preset (void);

	const ArsonIsoPresets &presets (void) const { return *m_presets; }
	ArsonIsoPresets &presets (void) { return *m_presets; }
	
	iso_option *findItem (QListViewItem *ptr);
	int findComboItem (const QString &name);
	void saveOptions (ArsonIsoFlags *pf);
	void addItem (iso_option *ptr);
	void buildOptionList (void);
	void applyOptions (void);

	ArsonIsoFlags *m_pCurFlags;		//	Currently selected preset
	ArsonIsoPresets *m_presets;		//	Container of preset configs
	OPTIONLIST m_items;				//	The options

	friend class isoOptionParser;

private slots:
	void on_accept (void);
};

/*========================================================*/
#endif	/*	__ISOPAGE_H__	*/
