;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ARIBAS by O. Forster
;;; file aritosco.asm
;;;
;;; date of last change
;;; 95-03-07, 96-01-01
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  Assembler-Code (SCO-UNIX) fuer primitive
;  Arithmetikfunktionen
;
;  Bemerkung: ints sind 4 Bytes lang; Rueckgabe erfolgt in eax
;
;  int multarr(word2 *x, int n, unsigned a, word2 *z);
;  int mult4arr(word2 *x, int n, word4 a, word2 *z);
;  int divarr(word2 *x, int n, unsigned a, word2 *rest);
;  int div4arr(word2 *x, int n, word4 a, word4 *rest);
;  unsigned modarr(word2 *x, int n, word2 a);
;  word4 mod4arr(word2 *x, int n, word4 a);
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        .386
        .model small

PUBLIC _multarr, _mult4arr, _divarr, _div4arr, _mod4arr, _modarr

_TEXT   SEGMENT  DWORD USE32 PUBLIC 'CODE'

; Assembler-Code fuer die C-Funktionen
; int multarr(word2 *x, int n, unsigned a, word2 *z);
; int mult4arr(word2 *x, int n, word4 a, word2 *z);

_mult4arr:
_multarr:
        push    ebp
        mov     ebp,esp
	push	ebx
        push    edi
        push    esi

        mov     esi, DWORD PTR[ebp+8]   ; Adresse x
        mov     edi, DWORD PTR[ebp+20]  ; Adresse z
        mov     ecx, DWORD PTR[ebp+12]  ; n
        cmp     ecx,0
        jle     mult0exit
        cld                                     ; direction upwards
        cmp     DWORD PTR [ebp],1               ; a = 1 ?
	ja	multstart
        jb      mult0exit	; multiplication by 0
	rep     movsw 		; multiplication by 1
        mov     eax,DWORD PTR [ebp+12]  ; n
	jmp	multexit
  multstart:
        mov     ebx,0           ; first carry = 0
	jmp	mloopentry
  multloop:
        lodsd                   ; eax <-- [esi] and increase esi by 4
        mul     DWORD PTR [ebp+16]        ; multiply eax by a
        add     eax,ebx         ; add carry
        adc     edx,0
        mov     ebx,edx         ; new carry
        stosd                   ; [edi] <-- eax and increase edi by 4
  mloopentry:
        sub     ecx,2
        jge     multloop

  mul_L0:
        cmp     ecx,-1                  ; n odd?
	jne	mul_L10
        movzx   eax, WORD PTR [esi]     ; n is odd
        mul     DWORD PTR [ebp+16]      ; multiply by a
        add     eax,ebx
        adc     edx,0
        mov     ebx,edx                 ; last carry < 2**16
        mov     ecx,DWORD PTR [ebp+12]  ; n
        cmp     ebx,0
	je	mul_L1
        add     ecx,2
	stosd
        mov     WORD PTR [edi],bx
	jmp	multweiter
  mul_L1:
        cmp     eax,10000h
        jb      mul_L2
        inc     ecx
	stosd
	jmp	multweiter
  mul_L2:
        mov     WORD PTR[edi],ax
	jmp	multweiter
  mul_L10:
        mov     ecx,DWORD PTR[ebp+12]   ; n
        cmp     ebx,10000h
	jb	mul_L11
        add     ecx,2
        mov     DWORD PTR[edi],ebx
	jmp	multweiter
  mul_L11:
        cmp     ebx,0
	jz	multweiter
        inc     ecx
        mov     WORD PTR[edi],bx
  multweiter:
        mov     eax,ecx
        jmp 	multexit
  mult0exit:
        mov     eax,0
  multexit:
        pop     esi
        pop     edi
	pop	ebx
        pop     ebp
        ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Assembler-Routinen fuer die C-Funktionen
; int divarr(word2 *x, int n, word2 a, word2 *rest);
; int div4arr(word2 *x, int n, word4 a, word4 *rest);
; Arbeitet destruktiv auf x; x wird Quotient, Rest in *rest
; Rueckgabewert Laenge des Quotienten

_div4arr:
        push    ebp
        mov     ebp,esp
	sub 	esp,2
	push	ebx
        push    edi
        push    esi
	mov	WORD PTR[ebp-2],4	; indicates division by word4
	jmp	divcomm
_divarr:
        push    ebp
        mov     ebp,esp
	sub 	esp,2
	push	ebx
        push    edi
        push    esi
	mov	WORD PTR[ebp-2],2 	; indicates division by word2	
  divcomm:
        mov     esi,DWORD PTR[ebp+8]    ; Adresse x
        mov     ebx,DWORD PTR[ebp+16]   ; a
        cmp     ebx,0
        jz      div0exit
        mov     ecx,DWORD PTR[ebp+12]   ; n
        sub     ecx,1
        jl      div0exit
        add     ecx,ecx
        add     esi,ecx                 ; address of x[n-1]
	mov	edi,esi			; save address of x[n-1]
	mov	edx,0
        mov     ecx, DWORD PTR[ebp+12]  ; n
        test    ecx,1
        jz      divide                  ; if n is even
        movzx   eax, WORD PTR[esi]      ; here n is odd
        div     ebx
        mov     WORD PTR[esi],ax
        sub     esi,2
        dec     ecx
	jz	div_L1
  divide:
        sub     esi,2
  divloop:
	mov	eax, DWORD PTR[esi]
        div     ebx
	mov	DWORD PTR[esi],eax
	sub	esi,4
        sub     ecx,2
        jg      divloop

  div_L1:					; adjust n
        mov     ecx, DWORD PTR[ebp+12]    	; n
	mov	ax,WORD PTR[edi]		; x[n-1]
        cmp     ax,0
	jnz	divweiter
        dec     ecx             ; decrease n if x[n-1] = 0
	jz	divweiter
	sub	edi,2
	mov	ax,WORD PTR[edi]
        cmp     ax,0
	jnz	divweiter
        dec     ecx		; decrease n if x[n-1] = 0
	jmp	divweiter
  div0exit:
        mov     ecx,0
        mov     edx,0
  divweiter:
        mov     eax,ecx
        mov     edi,DWORD PTR[ebp+20]   ; address rest
	cmp	WORD PTR[ebp-2],4
	jl	div_L2
        mov     DWORD PTR[edi],edx      ; store rest (word4)
	jmp	div_L10
  div_L2:
	mov	WORD PTR[edi],dx	; store rest (word2)
  div_L10:
        pop     esi
        pop     edi
	pop	ebx
	add	esp,2
        pop     ebp
        ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Assembler-Routine fuer die C-Funktion
; word2 modarr(word2 *x, int n, unsigned a);
; word4 mod4arr(word2 *x, int n, word4 a);
; Das Array (x,n) bleibt erhalten
; Es wird auch bei modarr vorausgesetzt, dass a als
; 4-byte-Zahl auf dem Stack uebergeben wird.
;
_mod4arr:
_modarr:
        push    ebp
        mov     ebp,esp
	push	ebx
        push    esi

        mov     esi,DWORD PTR[ebp+8]    ; Adresse x
        mov     ebx, DWORD PTR[ebp+16]  ; a
        mov     ecx, DWORD PTR[ebp+12]  ; n
        cmp     ebx,0
        jz      mod0exit                ; Division durch 0
        sub     ecx,1                   ; ecx = n-1
        jl      mod0exit
        add     ecx,ecx
        add     esi,ecx			; address of x[n-1]
        mov     edx,0
        mov     ecx, DWORD PTR[ebp+12]  ; n
        test    ecx,1                   ; is n odd?
	jz	modstart		; if n is even
        movzx   eax, WORD PTR[esi]
        div     ebx
        sub     esi,2
        dec     ecx
	jz	modexit
  modstart:
        sub     esi,2
  modloop:
	mov	eax, DWORD PTR[esi]
        div     ebx
	sub	esi,4
        sub     ecx,2
        jg      modloop
        jmp	modexit
  mod0exit:
        mov     edx,0
  modexit:
        mov     eax,edx
        pop     esi
	pop	ebx
        pop     ebp
        ret

_TEXT ENDS
END
