# 
# new-on-branch.sh: list tree patches new to a branch
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "list tree patches new to a branch\\n"
                printf "usage: new-on-branch [options] [archive/]version\\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf " -R --root root                specify the local archive root\\n"
                printf " -A --archive archive          specify the archive name\\n"
                printf "\\n"
                printf " -r --reverse                  list from most to least recent\\n"
		printf " -d --dir DIR                  cd to DIR first\\n"
                printf "\\n"
                printf "List all patch log entrees in the tree containing DIR that have\\n"
                printf "not already been merged with VERSION.\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=
reverse=
dir=
debug_opt=

while test $# -ne 0 ; do

  case "$1" in 

    --debug)		shift
    			debug_opt=--debug
			printf "\n" 1>&2
			printf "new-on-branch: DEBUGGING ACTIVATED\n" 1>&2
			printf "\n" 1>&2
			set -x
			;;
			
    -r|--reverse)      shift
    		       reverse=-r
		       ;;

    -d|--dir)          shift
                        if test $# -eq 0 ; then
                          printf "new-on-branch: -d and --dir require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        dir="$1"
                        shift
                        ;;

    -R|--root)          shift
                        if test $# -eq 0 ; then
                          printf "new-on-branch: -R and --root require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archroot="$1"
                        shift
                        ;;

    -A|--archive)       shift
                        if test $# -eq 0 ; then
                          printf "new-on-branch: -A and --archive require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archive="$1"
                        shift
                        ;;

    --)			shift
    			break
			;;
			
    -*)                 printf "new-on-branch: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: new-on-branch [options] [archive/]version\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

arch_vsn_spec="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

here="`pwd`"
cd "$dir"
wdroot="`larch tree-root --accurate`"


################################################################
# Print the List
# 

cd "$wdroot"
tmpdir=",,new-on-branch.$$"

bail()
{
  cd "$wdroot"
  rm -rf "$tmpdir"
  exit 1
}

trap "printf \"new-on-branch.sh: interrupted -- cleaning up\\n\" 1>&2 ; bail" INT

rm -rf "$tmpdir"
mkdir "$tmpdir"

rm -f "$tmpdir/in-log" 

larch merge-points $debug_opt --dir "$wdroot" "$arch_vsn_spec" \
| awk '{ print $2 }' \
| sort \
> "$tmpdir/already-merged"

larch logs $debug_opt \
| xargs need-args "larch log-ls $debug_opt --full" \
| sort \
> "$tmpdir/in-log"

join -v 2 -o 2.1 -1 1 -2 1 "$tmpdir/already-merged" "$tmpdir/in-log" \
| sed -e 's/\(.*--\)\(.*\)-\(.*\)/\2 \3 \1/g' \
| sort -k 3,3 -k 1,1${reverse#-} -k 2,2${reverse#-}n \
| sed -e 's/\([^ ]*\) \([^ ]*\) \(.*\)/\3\1-\2/'

cd "$wdroot"
rm -rf "$tmpdir"

# tag: Tom Lord Mon Jan  7 15:53:11 2002 (patch-logs/new-on-branch.sh)
#
