# cat-library-file.sh: output a file in a revision library
# 
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "output a file in a revision library\\n"
                printf "usage: cat-library-file [options] file [archive/]revision\\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf " -R --root root                specify the local archive root\\n"
                printf " -A --archive archive          specify the archive name\\n"
                printf "\\n"
                printf " --tag                         interpret FILE as an inventory tag\\n"
                printf " --this                        find the tag of FILE relative to\\n"
                printf "                                 the current directory, then find\\n"
                printf "                                 the corresponding file in the library\\n"
                printf "\\n"
                printf " --silent                      don't print an error message\\n"
                printf " -e --errname NAME             use NAME in error messages\\n"
                printf "\\n"
		printf "Print the contents of FILE in REVISION in your revision\\n"
		printf "library. If the revision or file is not present, print\\n"
		printf "an error message (unless \"--silent\" is specified) and\\n"
		printf "exit with non-0 status.\\n"
		printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

tag=
this=

silent=
errname=cat-library-file


while test $# -ne 0 ; do

  case "$1" in 

    --tag)		shift
    			tag=--tag
			this=
			;;

    --this)		shift
    			tag=
			this=--this
			;;

    -e|--errname)		shift
				if test $# -eq 0 ; then
				  printf "cat-library-file: -e and --errname require an argument\\n" 1>&2
				  printf "try --help\\n" 1>&2
				  exit 1
				fi
				errname="$1"
				shift
				;;

    -s|--silent)	shift
    			silent=--silent
			;;

    -R|--root)          shift
                        if test $# -eq 0 ; then
                          printf "cat-library-file: -R and --root require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archroot="$1"
                        shift
                        ;;

    -A|--archive)       shift
                        if test $# -eq 0 ; then
                          printf "cat-library-file: -A and --archive require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archive="$1"
                        shift
                        ;;

    -*)                 printf "cat-library-file: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 1 -o $# -gt 2 ; then
  printf "usage: cat-library-file [options] file [[archive/]revision]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

file="$1"
shift

if test $# -ne 0 ; then
  rvnspec="$1"
  shift
else
  rvnspec=
fi

################################################################
# Do It
# 

path="`larch library-file $this $tag \"$file\" \"$rvnspec\"`"
cat "$path"

# tag: Tom Lord Sun Jan 20 03:25:28 2002 (library/cat-library-file.sh)
#
