# 
# arch-rmrf.sh: recursively remove an archive file or directory
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "*recursively remove an archive file or directory\\n"
		printf "usage: arch-rmrf [options] file\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "rm -rf for files in an archive.\\n"
		printf "\\n"
		printf "DANGER: This is an \"internal command\".  You should probably\\n"
		printf "not be using it because it can completely trash an archive.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    -*)			printf "arch-rmrf: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
    printf "usage: arch-rmrf [options] file\\n" 1>&2
    printf "try --help\\n" 1>&2
    exit 1
fi

file="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 


################################################################
# Do It
# 
# 

there="`wftp-pwd`"

if wftp-cd "$file" > /dev/null 2>&1 ; then

  for f in `wftp-ls` ; do
    larch arch-rmrf "$f"
  done

  wftp-cd "$there"
  wftp-rmdir "$file"

else

  wftp-delete "$file"

fi

# tag: Tom Lord Sun Dec 16 05:01:17 2001 (archive-transactions/arch-rmrf.sh)
#
