/*
 * Copyright 2001 Guido Guenther <agx@sigxcpu.org>
 *
 * load arcboots configuration file and process the arguments
 *
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <types.h>

#include <sys/types.h>
#include <linux/ext2_fs.h>
#include <ext2fs.h>
#include "arcboot.h"

#define _PARM_LIMIT	32

static	char	*carray[_PARM_LIMIT+3]; /* 0 is the name, 1 the boofile, _PARM_LIMIT is OSLoadOptions */

CHAR** GetConfig(char* config, char* name)
{
	char *t, *start, *end;
	int		i;

	/* Loop on lines */
	while(*config != 0x0) {

		start=config;

		while(*config != 0xa && *config != 0x0) {
			/* Delete comments */
			if (*config == '#') 
				*config=0x0;
			config++;
		}

		/* Did we stop at the end of a line ? */
		if (*config == 0xa) {
			/* Terminate Line */
			*config=0x0;
			config++;
		}		

		/* Skip leading spaces and tabs */
		while(*start == ' ' || *start == '\t') 
			start++;

		/* If the start of a line is the end - Next line */
		if (*start == 0x0)
			continue;

		/* get the end pointer */
		end=&start[strlen(start)-1];

		/* Delete spaces and tabs at the end of a line */
		while(*end == ' ' || *end == '\t')
			*end--=0x0;

		if (strncmp("label=",start,6) == 0) {
			/* If we found the right profile or want the first */
			if (carray[0])
				if (((strcmp(carray[0], name) == 0) && (strcmp(name, carray[0]) == 0))) {
					return carray;
				}
			/* Reset image & append */
			carray[1]=carray[2]=0;
			carray[0]=&start[6];
		} else if (strncmp("image=",start,6) == 0) {
			carray[1]=&start[6];
		} else if (strncmp("append=",start,7) == 0) {
			t=&start[7];
			/* Does append start with " */
			if (*t == '"') {
				t++;
				/* If so - append starts +1 */
				carray[2]=t;
				/* Search ending quote */
				while(*t != '"' && *t != 0x0)
					t++;
				/* And delete */
				if (*t == '"') 
					*t=0x0;
			} else 
				carray[2]=&start[7];
			t=carray[2];
			i=3;
			while(i<_PARM_LIMIT && *t != 0x0) {
				t++;
					
				if (*t == ' ' || *t == '\t') {
					*t++=0x0;
					if (*t != 0x0)
						carray[i++]=t;
				}
			}
		}
	}
	if (carray[0])
		if ((name == NULL) ||
			(strcmp(carray[0], name) == 0)) {
			return carray;
		}
	/* Found nothing appropriate: */
	return NULL;
}

CHAR** ReadConfFile(const char *partition, const char *filename, char* label)
{
	ext2_file_t file;
	unsigned size, num_read;
	errcode_t status;
	char *conf_file;

	if(!OpenFile( partition, filename, &file )){
		printf("Can't open configuration file\n\r");
		return False;
	}		

	size = ext2fs_file_get_size(file);
	conf_file = malloc(size);
	if( !conf_file ) {
		printf("Can't read configuration file - not enough memory\n\r");
		return False;
	}
	status = ext2fs_file_read(file,(char*) conf_file, size, &num_read);
	if( status ) {
		print_ext2fs_error(status);
		return False;
	}
	if( size != num_read ) {
		printf("Wanted: %u, got %u bytes of configuration file\n\r", size, num_read);
		return False;
	}
	return GetConfig(conf_file, label); 
}
