/***************************************************************************
 $RCSfile: getstandingorders.cpp,v $
                             -------------------
    cvs         : $Id: getstandingorders.cpp,v 1.6 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Sun Jun 16 2002
    copyright   : (C) 2002 by Fabian Kaiser
    email       : openhbci@derzach.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


/*
 */

#include "getstandingorders.h"


HBCI::Error getStandingOrders(HBCI::Pointer<AQMAPI> hbciif,
			      HBCI::SimpleConfig &opt){
    HBCI::Pointer<HBCI::OutboxJob> job;
    HBCI::Tree<HBCI::ConfigNode>::iterator var;
    int country;
    string instid;
    string custid;
    string accnr;
    list<HBCI::Pointer<HBCI::Account> > accounts;
    list<HBCI::Pointer<HBCI::Account> >::iterator ait;
    HBCI::Error err;
    HBCI::Pointer<HBCI::User> customer;
    HBCI::Pointer<HBCI::Customer> cust;

    job.setDescription("getStandingOrder:job (HBCI::OutboxJob)");
    country=opt.getIntVariable("country",0,opt.root());
    instid=opt.getVariable("instid","*",opt.root());
    custid=opt.getVariable("customer","",opt.root());
    accnr=opt.getVariable("accnr","*",opt.root());
    // get accounts
    accounts=hbciif.ref().getAccounts(country,
                                      instid,
                                      accnr);
    if (accounts.empty())
        return HBCI::Error("getStandingOrders()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         "account not found");

    // create jobs
    for (ait=accounts.begin();
         ait!=accounts.end();
         ait++) {
        // create job for this account
        // get authorized customer for this account
        if (!custid.empty()) {
            // customer given
            cust=(*ait).ref().bank().ref().findCustomer(custid);
            if (!cust.isValid())
                return HBCI::Error("getstandingorders()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "customer not found");
            if (!((*ait).ref().isAuthorized(cust)))
                return HBCI::Error("getstandingorders()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "customer is not authorized");
        }
        else {
            // not given, try the first in the list
            list<HBCI::Pointer<HBCI::Customer> > custlist;

            custlist=(*ait).ref().authorizedCustomers();
            if (custlist.empty())
                return HBCI::Error("getstandingorders()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "no authorized customer for this account");
            cust=custlist.back();
        }


        job=new HBCI::OutboxJobGetStandingOrders(cust,*ait);
        // enqueue job
        hbciif.ref().addJob(job);
    } // for

    try {
        // execute queue
        err=hbciif.ref().executeQueue(true);
    }
    catch (HBCI::Error lerr) {
        err=lerr;
    }

    return err;
}


