#ifndef EXPIRATION_H_
#define EXPIRATION_H_

#include "config.h"
#include "meta.h"
#include "dirwalk.h"
#include "maintenance.h"
#include "lockable.h"
#include "csmapping.h"
#include "bgtask.h"

#include <set>

class dlcon;
class tDlJobHints;

// caching all relevant file identity data and helper flags in such entries
struct tDiskFileInfo {
	MYSTD::string sDirname;
	time_t nLostAt;
	tFingerprint fpr;
	bool bHeaderTestDone;
	
	tDiskFileInfo(MYSTD::string sDir, time_t now):
	sDirname(sDir),
	nLostAt(now),
	bHeaderTestDone(false)
	{
		fpr.csType=CSTYPE_INVALID;
	};
};

/* 
 * Collect files into buckets (groups of those having the same filename).
 * They are considered equal while inserting, but later some may be more equal than others
 * (if fingerprint checks are used).
 */
typedef MYSTD::multimap<MYSTD::string, tDiskFileInfo> tS2DAT;


class expiration : public IFileHandler, public bgtask {

public:
	expiration(int);
	~expiration();
	
	virtual void Action(const MYSTD::string &);
	
	// FileHandler
	virtual bool ProcessRegular(const MYSTD::string &sPath, const struct stat &);
	virtual bool ProcessOthers(const MYSTD::string &sPath, const struct stat &);
	
protected:

	//friend class showexp;
	tStrSet m_volatileFiles;

	void _UpdateVolatileFiles();
	void _UpdateWithDiffs(dlcon &dl, tStrSet & listGuessedLocationsToTry);
	void _BusyDisplayLogs();
	void _Usermsg(MYSTD::string m);
	virtual void _HandlePkgEntry(const tRemoteFileInfo &entry);
	
	/*!
	 * As the name saids, processes all index files and calls a callback
	 * function maintenence::_HandlePkgEntry on each entry.
	 * 
	 * If a string set object is passed then a little optimization might be 
	 * enabled internally, which avoid repeated processing of a file when another
	 * one with the same contents was already processed. This is only applicable 
	 * having strict path checking disabled, though.
	 *   
	 * */
	void _ParseVolatileFilesAndHandleEntries(tStrSet *pDupeCatcher=NULL);
	bool _UpdateOne(dlcon &dl, const MYSTD::string & sFilePath, MYSTD::string &sErrOut, tDlJobHints *p=NULL);
	void _InjectBz2ed(const MYSTD::string & sTargetBasePath, 
			const MYSTD::string & sSrcTmpPath, const tStrSet & goodChecklist);
	bool _DownloadOne(dlcon &dl, const MYSTD::string & sFilePath, MYSTD::string &sErrOut);
	virtual void _LoadIgnoreList();
	virtual bool _CanBeIgnored(const MYSTD::string &);
		
	// File handler
	time_t m_nTimeNow;
	tStrPos m_nDropPrefLen;

	bool m_bErrAbort, m_bVerbose, m_bForceDownload;
	bool m_bScanInternals, m_bByPath, m_bByChecksum, m_bSkipHeaderChecks;
	int m_nErrorCount;
	
private:

	tS2DAT m_trashCandSet;
	tStrSet m_trashCandHeadSet; // just collect the list of seen head files
	tStrSet m_quickBadList;
	tStrSet m_ignList;
	tStrSet m_uptodateTags;
	
	MYSTD::map<MYSTD::string,MYSTD::string> m_quickDupeHints; 

	void _RemoveAndStoreStatus(bool bPurgeNow);
	void _LoadTrashMapFromFile(bool bForceInsert);
	void _PurgeMaintLogs();
	
	unsigned int m_nProgIdx, m_nProgTold;

	expiration(const expiration&);
	expiration& operator=(const expiration&);
	
};


#endif /*EXPIRATION_H_*/
