; ======================================================================
; ricerca_binaria1.scm 
; Ricerca Binaria.
; ======================================================================

; ======================================================================
; (ricerca <vettore> <x> <ele-inf> <ele-sup>)
; ----------------------------------------------------------------------
(define (ricerca vettore x a z)
    (define m (truncate (/ (+ a z) 2)))

    (if (or (< m a) (> m z))
	; Non restano elementi da controllare: l'elemento cercato
	; non c'.
	-1

	(if (< x (vector-ref vettore m))
	    ; Si ripete la ricerca nella parte inferiore.
    	    (ricerca vettore x a (- m 1))

	    (if (> x (vector-ref vettore m))
    		; Si ripete la ricerca nella parte superiore.
		(ricerca vettore x (+ m 1) z)

		; Se x  uguale a vettore[m], l'obbiettivo 
		; stato trovato.
		m
	    )
	)
    )
)		

; ======================================================================
; Inizio del programma.
; ----------------------------------------------------------------------

(define DIM 100)
(define vettore (make-vector DIM))
(define x 0)
(define i 0)
(define z 0)

(display "Inserire la quantit di elementi; ")
(display DIM)
(display " al massimo: ")
(set! z (read))
(newline)

(if (> z DIM)
    (set! z DIM)
)

(display "Inserire i valori del vettore (in modo ordinato).")
(newline)
(do ( (i 0 (+ i 1)) )
    ( (>= i z) )

    (display "elemento ")
    (display i)
    (display " ")
    (vector-set! vettore i (read))
    (newline)
)

(display "Inserire il valore da cercare: ")
(set! x (read))
(newline)

(set! i (ricerca vettore x 0 (- z 1)))

(display "Il valore cercato si trova nell'elemento ")
(display i)
(newline)

; ======================================================================
