#!/usr/bin/perl
#======================================================================
# hanoi.pl <n-anelli> <piolo-iniziale> <piolo-finale>
#======================================================================

#======================================================================
# &hanoi ( <n-anelli>, <piolo-iniziale>, <piolo-finale> )
#----------------------------------------------------------------------
sub hanoi {
    local( $n ) = @_[0];
    local( $p1 ) = @_[1];
    local( $p2 ) = @_[2];

    if ($n > 0) {
	&hanoi ($n-1, $p1, 6-$p1-$p2);
	print "Muovi l'anello $n dal piolo $p1 al piolo $p2\n";
	&hanoi ($n-1, 6-$p1-$p2, $p2);
    };
};
#======================================================================

#======================================================================
# Inizio del programma.
#----------------------------------------------------------------------
$n = $ARGV[0];
$p1 = $ARGV[1];
$p2 = $ARGV[2];

&hanoi ($n, $p1, $p2);

#======================================================================

