/* ================================================================= */
/* permuta <valore>...						     */
/* Permutazioni.						     */
/* ================================================================= */

#include <stdio.h>

int iDimArray;

/* ================================================================= */
/* visualizza ( <array>, <dimensione> )				     */
/* ----------------------------------------------------------------- */
void visualizza( int lista[], int dimensione ) {

    int i;

    for ( i = 0; i < dimensione; i++ ) {
	printf( "%d ", lista[i] );
    }
    printf( "\n" );
}

/* ================================================================= */
/* permuta ( <lista>, <inizio>, <fine> )			     */
/* ----------------------------------------------------------------- */
void permuta( int lista[], int a, int z ) {

    int scambio;
    int k;

    /* Se il segmento di array contiene almeno due elementi, si	     */
    /* procede.							     */
    if ( (z - a) >= 1 ) {

	/* Inizia un ciclo di scambi tra l'ultimo elemento e uno     */
	/* degli altri contenuti nel segmento di array.		     */
        for ( k = z; k >= a; k-- ) {

	    /* Scambia i valori.				     */
            scambio = lista[k];
            lista[k] = lista[z];
            lista[z] = scambio;

	    /* Esegue una chiamata ricorsiva per permutare un	     */
	    /* segmento pi piccolo dell'array.			     */
	    permuta( lista, a, z-1 );

	    /* Scambia i valori.				     */
            scambio = lista[k];
            lista[k] = lista[z];
            lista[z] = scambio;
        }
    } else {
	/* Visualizza l'array e utilizza una variabile dichiarata    */
	/* globalmente.						     */
	visualizza( lista, iDimArray );
    }
}

/* ================================================================= */
/* Inizio del programma.					     */
/* ----------------------------------------------------------------- */
main( int argc, char *argv[] ) {

    int lista[argc-1];
    int i;

    /* Considera gli argomenti come gli elementi		     */
    /* dell'array da permutare.					     */
    for ( i = 1; i < argc; i++ ) {
	sscanf( argv[i], "%d", &lista[i-1] );
    }

    /* Salva la dimension dell'array nella variabile globale.	     */
    iDimArray = argc-1;

    /* Esegue le permutazioni.					     */
    permuta( lista, 0, argc-2);
}
