/* ================================================================= */
/* bsort <valore>...						     */
/* BubbleSort.							     */
/* ================================================================= */

#include <stdio.h>

/* ================================================================= */
/* bsort ( <lista>, <inizio>, <fine> )				     */
/* ----------------------------------------------------------------- */
void bsort( int lista[], int a, int z ) {

    int scambio;
    int j;
    int k;

    /* Inizia il ciclo di scansione dell'array.			     */
    for ( j = a; j < z; j++ ) {

	/* Scansione interna dell'array per collocare nella	     */
	/* posizione j l'elemento giusto.			     */
        for ( k = j+1; k <= z; k++ ) {

            if ( lista[k] < lista[j] ) {

		/* Scambia i valori.				     */
                scambio = lista[k];
                lista[k] = lista[j];
                lista[j] = scambio;
            }
        }
    }
}

/* ================================================================= */
/* Inizio del programma.					     */
/* ----------------------------------------------------------------- */
main( int argc, char *argv[] ) {

    int lista[argc-1];
    int i;

    /* Considera gli argomenti come gli elementi		     */
    /* dell'array da ordinare.					     */
    for ( i = 1; i < argc; i++ ) {
	sscanf( argv[i], "%d", &lista[i-1] );
    }

    /* Esegue il riordino.					     */
    bsort( lista, 0, argc-2);

    /* Emette il risultato.					     */
    for ( i = 0; i < (argc-1); i++ ) {
	printf( "%d ", lista[i] );
    }
    printf( "\n" );
}
